/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.draconicevolution;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedString;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.lib.EnergyCoreBuilder;
import com.nomiceu.nomilabs.integration.draconicevolution.EnergyCoreDestructor;
import com.nomiceu.nomilabs.integration.draconicevolution.ImprovedTileEnergyCore;
import com.nomiceu.nomilabs.integration.draconicevolution.StoppableProcess;
import com.nomiceu.nomilabs.integration.draconicevolution.TileEnergyStorageCoreLogic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TileEnergyStorageCore.class}, remap=false)
public abstract class TileEnergyStorageCoreMixin
extends TileBCBase
implements ImprovedTileEnergyCore {
    @Unique
    private static final String ACTIVE_BUILDER = "activeBuilder";
    @Unique
    private static final String ACTIVE_DESTRUCTOR = "activeDestructor";
    @Unique
    private static final String EXPECTED_STRING = "expectedBlock";
    @Unique
    private static final String EXPECTED_POS = "expectedPos";
    @Shadow
    private EnergyCoreBuilder activeBuilder;
    @Unique
    private EnergyCoreDestructor activeDestructor;
    @Unique
    public ManagedBool hasActiveBuilder;
    @Unique
    public ManagedBool hasActiveDestructor;
    @Unique
    public ManagedString expectedBlockString;
    @Unique
    public ManagedVec3I expectedBlockPos;

    @Shadow
    protected abstract long getCapacity();

    @Shadow
    protected abstract void updateStabilizers(boolean var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void initFields(CallbackInfo ci) {
        this.hasActiveBuilder = (ManagedBool)this.register(ACTIVE_BUILDER, (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().trigerUpdate().finish();
        this.hasActiveDestructor = (ManagedBool)this.register(ACTIVE_DESTRUCTOR, (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().trigerUpdate().finish();
        this.expectedBlockString = (ManagedString)this.register(EXPECTED_STRING, (IManagedData)new ManagedString("")).syncViaTile().saveToTile().trigerUpdate().finish();
        this.expectedBlockPos = (ManagedVec3I)this.register(EXPECTED_POS, (IManagedData)new ManagedVec3I(new Vec3I(0, 0, 0))).syncViaTile().saveToTile().trigerUpdate().finish();
    }

    @Inject(method={"activateCore"}, at={@At(value="HEAD")}, cancellable=true)
    public void activateCore(CallbackInfo ci) {
        TileEnergyStorageCoreLogic.activateCore((TileEnergyStorageCore)this, this.getCapacity());
        this.updateStabilizers(true);
        ci.cancel();
    }

    @Inject(method={"deactivateCore"}, at={@At(value="HEAD")}, cancellable=true)
    public void deactivateCore(CallbackInfo ci) {
        TileEnergyStorageCoreLogic.deactivateCore((TileEnergyStorageCore)this);
        this.updateStabilizers(false);
        ci.cancel();
    }

    @Inject(method={"validateStructure"}, at={@At(value="HEAD")}, cancellable=true)
    public void validateStructure(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)TileEnergyStorageCoreLogic.validateStructure((TileEnergyStorageCore)this));
    }

    @Inject(method={"receivePacketFromClient"}, at={@At(value="HEAD")}, cancellable=true)
    public void receivePacketFromClient(MCDataInput data, EntityPlayerMP client, int id, CallbackInfo ci) {
        TileEnergyStorageCore tile = (TileEnergyStorageCore)this;
        tile.validateStructure();
        switch (id) {
            case 0: {
                if (tile.active.value) {
                    tile.deactivateCore();
                    break;
                }
                tile.activateCore();
                break;
            }
            case 1: {
                if (tile.active.value || tile.tier.value >= 8) break;
                tile.tier.value = (byte)(tile.tier.value + 1);
                tile.buildGuide.value = false;
                tile.validateStructure();
                break;
            }
            case 2: {
                if (tile.active.value || tile.tier.value <= 1) break;
                tile.tier.value = (byte)(tile.tier.value - 1);
                tile.buildGuide.value = false;
                tile.validateStructure();
                break;
            }
            case 3: {
                if (tile.active.value || tile.coreValid.value || tile.tier.value == 1) break;
                tile.buildGuide.value = !tile.buildGuide.value;
                break;
            }
            case 4: {
                if (tile.active.value || tile.coreValid.value || this.hasActiveDestructor.value) break;
                this.startOrStopBuilder((EntityPlayer)client);
                break;
            }
            case 7: {
                if (!tile.coreValid.value || tile.active.value || this.hasActiveBuilder.value || tile.tier.value == 1) break;
                this.startOrStopDestructor((EntityPlayer)client);
            }
        }
        ci.cancel();
    }

    @Inject(method={"update()V"}, at={@At(value="HEAD")})
    public void updateDevEnv(CallbackInfo ci) {
        this.updateLogic();
    }

    @Inject(method={"func_73660_a()V"}, at={@At(value="HEAD")})
    public void updateObf(CallbackInfo ci) {
        this.updateLogic();
    }

    @Unique
    private void updateLogic() {
        TileEnergyStorageCore tile = (TileEnergyStorageCore)this;
        if (tile.func_145831_w().field_72995_K) {
            return;
        }
        if (this.activeBuilder == null) {
            this.hasActiveBuilder.value = false;
        } else if (this.activeBuilder.isDead()) {
            this.hasActiveBuilder.value = false;
        }
        if (this.activeDestructor == null) {
            this.hasActiveDestructor.value = false;
        } else if (this.activeDestructor.isDead()) {
            this.activeDestructor = null;
            this.hasActiveDestructor.value = false;
        } else {
            this.activeDestructor.updateDestructProcess();
        }
    }

    @Unique
    private void startOrStopBuilder(EntityPlayer player) {
        if (this.hasActiveBuilder.value) {
            if (this.activeBuilder != null) {
                ((StoppableProcess)this.activeBuilder).stop();
            }
            this.activeBuilder = null;
            this.hasActiveBuilder.value = false;
            return;
        }
        this.activeBuilder = new EnergyCoreBuilder((TileEnergyStorageCore)this, player);
        if (this.activeBuilder.isDead()) {
            this.hasActiveBuilder.value = false;
            this.activeBuilder = null;
        } else {
            this.hasActiveBuilder.value = true;
        }
    }

    @Unique
    private void startOrStopDestructor(EntityPlayer player) {
        if (this.hasActiveDestructor.value) {
            if (this.activeDestructor != null) {
                this.activeDestructor.stop();
            }
            this.activeDestructor = null;
            this.hasActiveDestructor.value = false;
            return;
        }
        this.activeDestructor = new EnergyCoreDestructor((TileEnergyStorageCore)this, player);
        if (this.activeDestructor.isDead()) {
            this.hasActiveDestructor.value = false;
            this.activeDestructor = null;
        } else {
            this.hasActiveDestructor.value = true;
        }
    }

    @Override
    @Unique
    public boolean hasActiveBuilder() {
        return this.hasActiveBuilder.value;
    }

    @Override
    @Unique
    public boolean hasActiveDestructor() {
        return this.hasActiveDestructor.value;
    }

    @Unique
    public void onLoad() {
        super.onLoad();
        this.hasActiveBuilder.value = this.activeBuilder != null;
        this.hasActiveDestructor.value = this.activeDestructor != null;
    }

    @Override
    @Unique
    public void setExpectedBlockString(String string) {
        this.expectedBlockString.value = string;
    }

    @Override
    @Unique
    public void setExpectedBlockPos(BlockPos pos) {
        this.expectedBlockPos.vec = new Vec3I(pos);
    }

    @Override
    @Unique
    public String getExpectedBlockString() {
        return this.expectedBlockString.value;
    }

    @Override
    @Unique
    public Vec3I getExpectedBlockPos() {
        return this.expectedBlockPos.vec;
    }
}

