/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.earlygroovy;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.compat.vanilla.Crafting;
import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import com.cleanroommc.groovyscript.registry.ReloadableRegistryManager;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.groovy.mixinhelper.CraftingOutputCache;
import com.nomiceu.nomilabs.util.ItemMeta;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Crafting.class}, remap=false)
public class CraftingMixin {
    @Inject(method={"removeByOutput(Lcom/cleanroommc/groovyscript/api/IIngredient;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void useOutputCache(IIngredient output, boolean log, CallbackInfo ci) {
        IIngredient iIngredient;
        if (LabsConfig.groovyScriptSettings.craftingOutputCacheMode == LabsConfig.GroovyScriptSettings.CraftingOutputCacheMode.DISABLED) {
            return;
        }
        if (IngredientHelper.isEmpty((IIngredient)output) || !((iIngredient = output) instanceof ItemStack)) {
            return;
        }
        ItemStack stack = (ItemStack)iIngredient;
        ci.cancel();
        CraftingOutputCache.buildCache();
        ItemMeta itemMeta = new ItemMeta(stack);
        if (!CraftingOutputCache.cache.containsKey(itemMeta)) {
            if (log) {
                GroovyLog.msg((String)"Error removing Minecraft Crafting recipe", (Object[])new Object[0]).add("No recipes found for {}", new Object[]{output}).error().post();
            }
            return;
        }
        for (ResourceLocation rl : CraftingOutputCache.cache.get(itemMeta)) {
            ReloadableRegistryManager.removeRegistryEntry((IForgeRegistry)ForgeRegistries.RECIPES, (ResourceLocation)rl);
        }
    }
}

