/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.enderio;

import com.nomiceu.nomilabs.config.LabsConfig;
import crazypants.enderio.base.xp.XpUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={XpUtil.class}, remap=false)
public class XPUtilMixin {
    @Inject(method={"calculateXPfromLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private static void calculateXpFromLevelLinear(int level, CallbackInfoReturnable<Long> cir) {
        if (LabsConfig.advanced.otherModsLinearXp != 0 && level >= 0) {
            cir.setReturnValue((Object)((long)LabsConfig.advanced.otherModsLinearXp * (long)level));
        }
    }

    @Inject(method={"getLevelFromExp"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getLevelFromXpLinear(long exp, CallbackInfoReturnable<Integer> cir) {
        if (LabsConfig.advanced.otherModsLinearXp != 0 && exp >= 0L) {
            cir.setReturnValue((Object)((int)(exp / (long)LabsConfig.advanced.otherModsLinearXp)));
        }
    }

    @Inject(method={"getXpBarCapacity"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getLinearXPAmount(int level, CallbackInfoReturnable<Integer> cir) {
        if (LabsConfig.advanced.otherModsLinearXp != 0 && level >= 0) {
            cir.setReturnValue((Object)LabsConfig.advanced.otherModsLinearXp);
        }
    }
}

