/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.gregtech;

import com.llamalad7.mixinextras.sugar.Local;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleAbstractRecipeLogic;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.chance.boost.ChanceBoostFunction;
import gregtech.api.recipes.chance.output.ChancedOutput;
import gregtech.api.recipes.chance.output.ChancedOutputList;
import gregtech.api.recipes.chance.output.ChancedOutputLogic;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={AbstractRecipeLogic.class}, remap=false)
public abstract class AbstractRecipeLogicMixin
extends MTETrait
implements AccessibleAbstractRecipeLogic {
    @Unique
    private static final String LABS_NON_CHANCED_ITEM_AMT_KEY = "labs$nonChancedItemAmt";
    @Unique
    private static final String LABS_CHANCED_ITEM_OUTPUTS_KEY = "labs$chancedItemOutputs";
    @Unique
    private static final String LABS_NON_CHANCED_FLUID_AMT_KEY = "labs$nonChancedFluidAmt";
    @Unique
    private static final String LABS_CHANCED_FLUID_OUTPUTS_KEY = "labs$chancedFluidOutputs";
    @Unique
    private static final String LABS_CHANCE_KEY = "chance";
    @Shadow
    protected NonNullList<ItemStack> itemOutputs;
    @Shadow
    protected List<FluidStack> fluidOutputs;
    @Shadow
    protected int recipeEUt;
    @Shadow
    protected int progressTime;
    @Shadow
    protected Recipe previousRecipe;
    @Unique
    private int labs$nonChancedItemAmt = 0;
    @Unique
    private List<Pair<ItemStack, Integer>> labs$chancedItemOutputs = null;
    @Unique
    private int labs$nonChancedFluidAmt = 0;
    @Unique
    private List<Pair<FluidStack, Integer>> labs$chancedFluidOutputs = null;

    @Shadow
    @Nullable
    public abstract RecipeMap<?> getRecipeMap();

    private AbstractRecipeLogicMixin(@NotNull MetaTileEntity metaTileEntity) {
        super(metaTileEntity);
    }

    @Override
    @Unique
    public boolean labs$isValidForOutputTop() {
        return this.labs$getEUt() >= 0 && this.getRecipeMap() != null;
    }

    @Override
    @Unique
    public List<ItemStack> labs$getOutputs() {
        if (this.itemOutputs == null) {
            NomiLabs.LOGGER.error("Item Outputs List for Recipe Logic {} of Recipe Map {} is null!", (Object)this.getClass().getName(), (Object)this.getRecipeMap().getUnlocalizedName());
            return new ArrayList<ItemStack>();
        }
        return this.itemOutputs;
    }

    @Override
    @Unique
    public List<FluidStack> labs$getFluidOutputs() {
        if (this.fluidOutputs == null) {
            NomiLabs.LOGGER.error("Fluid Outputs List for Recipe Logic {} of Recipe Map {} is null!", (Object)this.getClass().getName(), (Object)this.getRecipeMap().getUnlocalizedName());
            return new ArrayList<FluidStack>();
        }
        return this.fluidOutputs;
    }

    @Override
    @Unique
    public int labs$getEUt() {
        return this.recipeEUt;
    }

    @Override
    @Unique
    public int labs$getNonChancedItemAmt() {
        return this.labs$nonChancedItemAmt;
    }

    @Override
    @Unique
    public List<Pair<ItemStack, Integer>> labs$getChancedItemOutputs() {
        if (this.labs$chancedItemOutputs == null) {
            NomiLabs.LOGGER.error("Chanced Item Outputs List for Recipe Logic {} of Recipe Map {} is null!", (Object)this.getClass().getName(), (Object)this.getRecipeMap().getUnlocalizedName());
            return new ArrayList<Pair<ItemStack, Integer>>();
        }
        return this.labs$chancedItemOutputs;
    }

    @Override
    @Unique
    public int labs$getNonChancedFluidAmt() {
        return this.labs$nonChancedFluidAmt;
    }

    @Override
    @Unique
    public List<Pair<FluidStack, Integer>> labs$getChancedFluidOutputs() {
        if (this.labs$chancedFluidOutputs == null) {
            NomiLabs.LOGGER.error("Chanced Fluid Outputs List for Recipe Logic {} of Recipe Map {} is null!", (Object)this.getClass().getName(), (Object)this.getRecipeMap().getUnlocalizedName());
            return new ArrayList<Pair<FluidStack, Integer>>();
        }
        return this.labs$chancedFluidOutputs;
    }

    @Inject(method={"completeRecipe"}, at={@At(value="TAIL")})
    private void clearLabsValues(CallbackInfo ci) {
        this.labs$nonChancedItemAmt = 0;
        this.labs$chancedItemOutputs = null;
        this.labs$nonChancedFluidAmt = 0;
        this.labs$chancedFluidOutputs = null;
    }

    @Inject(method={"setupRecipe"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void setupLabsValues(Recipe recipe, CallbackInfo ci, @Local(ordinal=0) int recipeTier, @Local(ordinal=1) int machineTier) {
        this.labs$nonChancedItemAmt = recipe.getOutputs().size();
        this.labs$nonChancedFluidAmt = recipe.getFluidOutputs().size();
        this.labs$chancedItemOutputs = this.labs$fillChancedOutputsMap(recipe.getChancedOutputs(), this.getRecipeMap().getChanceFunction(), recipeTier, machineTier);
        this.labs$chancedFluidOutputs = this.labs$fillChancedOutputsMap(recipe.getChancedFluidOutputs(), this.getRecipeMap().getChanceFunction(), recipeTier, machineTier);
    }

    @Unique
    private <T> List<Pair<T, Integer>> labs$fillChancedOutputsMap(ChancedOutputList<T, ? extends ChancedOutput<T>> list, ChanceBoostFunction function, int recipeTier, int machineTier) {
        ArrayList<Pair<T, Integer>> result = new ArrayList<Pair<T, Integer>>();
        if (list.getChancedEntries().isEmpty()) {
            return result;
        }
        for (ChancedOutput entry : list.getChancedEntries()) {
            result.add(Pair.of((Object)entry.getIngredient(), (Object)Math.min(ChancedOutputLogic.getMaxChancedValue(), ChancedOutputLogic.getChance((ChancedOutput)entry, (ChanceBoostFunction)function, (int)recipeTier, (int)machineTier))));
        }
        return result;
    }

    @Inject(method={"deserializeNBT"}, at={@At(value="TAIL")})
    private void loadLabsValues(NBTTagCompound compound, CallbackInfo ci) {
        if (this.progressTime <= 0) {
            return;
        }
        this.labs$nonChancedItemAmt = compound.func_74762_e(LABS_NON_CHANCED_ITEM_AMT_KEY);
        this.labs$nonChancedFluidAmt = compound.func_74762_e(LABS_NON_CHANCED_FLUID_AMT_KEY);
        NBTTagList items = compound.func_150295_c(LABS_CHANCED_ITEM_OUTPUTS_KEY, 10);
        this.labs$chancedItemOutputs = new ArrayList<Pair<ItemStack, Integer>>();
        for (NBTBase item : items) {
            NBTTagCompound tag = (NBTTagCompound)item;
            this.labs$chancedItemOutputs.add((Pair<ItemStack, Integer>)Pair.of((Object)new ItemStack(tag), (Object)tag.func_74762_e(LABS_CHANCE_KEY)));
        }
        NBTTagList fluids = compound.func_150295_c(LABS_CHANCED_FLUID_OUTPUTS_KEY, 10);
        this.labs$chancedFluidOutputs = new ArrayList<Pair<FluidStack, Integer>>();
        for (NBTBase fluid : fluids) {
            NBTTagCompound tag = (NBTTagCompound)fluid;
            this.labs$chancedFluidOutputs.add((Pair<FluidStack, Integer>)Pair.of((Object)FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag), (Object)tag.func_74762_e(LABS_CHANCE_KEY)));
        }
    }

    @Inject(method={"serializeNBT"}, at={@At(value="RETURN")})
    private void saveLabsValues(CallbackInfoReturnable<NBTTagCompound> cir) {
        if (this.progressTime <= 0) {
            return;
        }
        NBTTagCompound nbt = (NBTTagCompound)cir.getReturnValue();
        nbt.func_74768_a(LABS_NON_CHANCED_ITEM_AMT_KEY, this.labs$nonChancedItemAmt);
        nbt.func_74768_a(LABS_NON_CHANCED_FLUID_AMT_KEY, this.labs$nonChancedFluidAmt);
        this.labs$addChancedToTag(nbt, LABS_CHANCED_ITEM_OUTPUTS_KEY, this.labs$chancedItemOutputs, entry -> ((ItemStack)entry.getKey()).func_77955_b(new NBTTagCompound()), Pair::getValue);
        this.labs$addChancedToTag(nbt, LABS_CHANCED_FLUID_OUTPUTS_KEY, this.labs$chancedFluidOutputs, entry -> ((FluidStack)entry.getKey()).writeToNBT(new NBTTagCompound()), Pair::getValue);
    }

    @Unique
    private <T> void labs$addChancedToTag(NBTTagCompound nbt, String key, List<T> list, Function<T, NBTTagCompound> createTag, Function<T, Integer> getChance) {
        if (list == null) {
            return;
        }
        NBTTagList entries = new NBTTagList();
        for (T entry : list) {
            NBTTagCompound tag = createTag.apply(entry);
            tag.func_74768_a(LABS_CHANCE_KEY, getChance.apply(entry).intValue());
            entries.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a(key, (NBTBase)entries);
    }

    @Override
    @Unique
    public void labs$clearRecipeCache() {
        this.previousRecipe = null;
    }
}

