/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.gregtech;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleMaterial;
import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleMaterialFlags;
import com.nomiceu.nomilabs.gregtech.mixinhelper.CompositionRecipeType;
import com.nomiceu.nomilabs.groovy.CompositionBuilder;
import com.nomiceu.nomilabs.mixin.gregtech.AccessibleMaterialInfo;
import gregtech.api.recipes.Recipe;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialFlag;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.stack.MaterialStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Material.class}, remap=false)
public abstract class MaterialMixin
implements AccessibleMaterial {
    @Unique
    private String setChemicalFormula;
    @Shadow
    private String chemicalFormula;
    @Unique
    private ImmutableList<MaterialStack> originalComponents = null;
    @Unique
    private boolean hasSetFlags = false;
    @Unique
    private boolean calculatedDecomp = false;
    @Unique
    private final Map<CompositionRecipeType, List<Recipe>> originalRecipes = new Object2ObjectOpenHashMap();
    @Unique
    private final MaterialFlag[] decompFlags = new MaterialFlag[]{MaterialFlags.DISABLE_DECOMPOSITION, MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING, MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING};
    @Shadow
    @Final
    @NotNull
    private MaterialFlags flags;

    @Shadow
    @NotNull
    protected abstract String calculateChemicalFormula();

    @Shadow
    protected abstract void calculateDecompositionType();

    @Shadow
    public abstract ImmutableList<MaterialStack> getMaterialComponents();

    @Override
    @Unique
    public void setComponents(ImmutableList<MaterialStack> components, boolean changeFormula) {
        this.setComponents(components);
        if (changeFormula) {
            this.chemicalFormula = this.setChemicalFormula;
            this.chemicalFormula = this.calculateChemicalFormula();
        }
        if (this.chemicalFormula == null) {
            this.chemicalFormula = "";
        }
        this.recalculateDecompositionType();
    }

    @Override
    @Unique
    public void setComponents(ImmutableList<MaterialStack> components) {
        if (this.originalComponents == null) {
            this.originalComponents = this.getMaterialComponents();
        }
        try {
            Field f = Material.class.getDeclaredField("materialInfo");
            ((AccessibleMaterialInfo)f.get(this)).setComponentList(components);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
            // empty catch block
        }
    }

    @Inject(method={"setFormula(Ljava/lang/String;Z)Lgregtech/api/unification/material/Material;"}, at={@At(value="RETURN")})
    private void setChemicalFormula(String formula, boolean withFormatting, CallbackInfoReturnable<Material> cir) {
        this.setChemicalFormula = this.chemicalFormula;
    }

    @Inject(method={"calculateDecompositionType"}, at={@At(value="HEAD")})
    private void saveSetFlags(CallbackInfo ci) {
        boolean hasDecompFlags = false;
        for (MaterialFlag flag : this.decompFlags) {
            if (!this.flags.hasFlag(flag)) continue;
            hasDecompFlags = true;
            break;
        }
        if (hasDecompFlags && !this.calculatedDecomp) {
            this.hasSetFlags = true;
        }
        this.calculatedDecomp = true;
    }

    @Inject(method={"addFlags([Lgregtech/api/unification/material/info/MaterialFlag;)V"}, at={@At(value="TAIL")})
    private void checkFlags(MaterialFlag[] flags, CallbackInfo ci) {
        if (this.hasSetFlags) {
            return;
        }
        for (MaterialFlag flag : this.decompFlags) {
            if (!ArrayUtils.contains((Object[])flags, (Object)flag)) continue;
            this.hasSetFlags = true;
            break;
        }
    }

    @Override
    @Unique
    public ImmutableList<MaterialStack> getOriginalComponents() {
        return this.originalComponents == null ? this.getMaterialComponents() : this.originalComponents;
    }

    @Override
    @Unique
    public void recalculateDecompositionType() {
        if (!this.hasSetFlags && this.calculatedDecomp) {
            ((AccessibleMaterialFlags)this.flags).removeFlags(MaterialFlags.DISABLE_DECOMPOSITION, MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING, MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING);
        }
        this.calculateDecompositionType();
    }

    @Unique
    public CompositionBuilder changeComposition() {
        return new CompositionBuilder((Material)this);
    }

    @Override
    public void setOriginalRecipes(CompositionRecipeType type, List<Recipe> originals) {
        if (this.originalRecipes.containsKey((Object)type)) {
            return;
        }
        this.originalRecipes.put(type, originals);
    }

    @Override
    public Map<CompositionRecipeType, List<Recipe>> getOriginalRecipes() {
        return ImmutableMap.copyOf(this.originalRecipes);
    }
}

