/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.gregtech;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleRecipeMap;
import com.nomiceu.nomilabs.groovy.RecyclingHelper;
import com.nomiceu.nomilabs.util.LabsGroovyHelper;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.category.GTRecipeCategory;
import gregtech.api.recipes.chance.output.impl.ChancedFluidOutput;
import gregtech.api.recipes.chance.output.impl.ChancedItemOutput;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.util.EnumValidationResult;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={RecipeBuilder.class}, remap=false)
public abstract class RecipeBuilderMixin<R extends RecipeBuilder<R>> {
    @Shadow
    @Final
    protected List<ItemStack> outputs;
    @Shadow
    @Final
    protected List<GTRecipeInput> inputs;
    @Shadow
    protected EnumValidationResult recipeStatus;
    @Shadow
    protected RecipeMap<R> recipeMap;
    @Shadow
    @Final
    protected List<FluidStack> fluidOutputs;
    @Shadow
    @Final
    protected List<ChancedItemOutput> chancedOutputs;
    @Shadow
    @Final
    protected List<ChancedFluidOutput> chancedFluidOutputs;
    @Shadow
    protected int EUt;
    @Shadow
    protected GTRecipeCategory category;

    @Shadow
    public abstract R inputNBT(GTRecipeInput var1, NBTMatcher var2, NBTCondition var3);

    @Shadow
    private static GTRecipeInput ofGroovyIngredient(IIngredient ingredient) {
        return null;
    }

    @Redirect(method={"lambda$multiplyInputsAndOutputs$1"}, at=@At(value="INVOKE", target="Lgregtech/api/recipes/ingredients/GTRecipeInput;withAmount(I)Lgregtech/api/recipes/ingredients/GTRecipeInput;"))
    private static GTRecipeInput fixCopyingInputs(GTRecipeInput instance, int amount) {
        return instance.copyWithAmount(amount);
    }

    @Redirect(method={"lambda$multiplyInputsAndOutputs$2"}, at=@At(value="INVOKE", target="Lgregtech/api/recipes/ingredients/GTRecipeInput;withAmount(I)Lgregtech/api/recipes/ingredients/GTRecipeInput;"))
    private static GTRecipeInput fixCopyingFluidInputs(GTRecipeInput instance, int amount) {
        return instance.copyWithAmount(amount);
    }

    @Unique
    public R changeRecycling() {
        if (!RecyclingHelper.changeStackRecycling(this.outputs, this.inputs)) {
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        return (R)((RecipeBuilder)this);
    }

    @Unique
    public R inputNBT(IIngredient ingredient, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(RecipeBuilderMixin.ofGroovyIngredient(ingredient), matcher, condition);
    }

    @Unique
    public R inputWildNBT(IIngredient ingredient) {
        return this.inputNBT(ingredient, NBTMatcher.ANY, NBTCondition.ANY);
    }

    @Unique
    public R replace(RecipeMap<?> ... otherMaps) {
        return this.replaceForMaps(otherMaps, map -> this.removeOrWarn((RecipeMap<?>)map, ((AccessibleRecipeMap)map).findByOutput(this.outputs, this.fluidOutputs, this.chancedOutputs, this.chancedFluidOutputs, r -> true), String.format("items: %s, fluids: %s, chanced items: %s, chanced fluids: %s", this.outputs, this.fluidOutputs, this.chancedOutputs, this.chancedFluidOutputs)));
    }

    @Unique
    public R replaceInCategory(RecipeMap<?> ... otherMaps) {
        return this.replaceForMaps(otherMaps, map -> this.removeOrWarn((RecipeMap<?>)map, ((AccessibleRecipeMap)map).findByOutput(this.outputs, this.fluidOutputs, this.chancedOutputs, this.chancedFluidOutputs, r -> Objects.equals(this.category, r.getRecipeCategory())), String.format("category: %s, items: %s, fluids: %s, chanced items: %s, chanced fluids: %s", this.category, this.outputs, this.fluidOutputs, this.chancedOutputs, this.chancedFluidOutputs)));
    }

    @Unique
    public R replaceWithVoltage(RecipeMap<?> ... otherMaps) {
        return this.replaceForMaps(otherMaps, map -> this.removeOrWarn((RecipeMap<?>)map, ((AccessibleRecipeMap)map).findRecipeByOutput(this.EUt, this.outputs, this.fluidOutputs, this.chancedOutputs, this.chancedFluidOutputs), String.format("voltage: %s, items: %s, fluids: %s, chanced items: %s, chanced fluids: %s", this.EUt, this.outputs, this.fluidOutputs, this.chancedOutputs, this.chancedFluidOutputs)));
    }

    @Unique
    public R replaceWithExactVoltage(RecipeMap<?> ... otherMaps) {
        return this.replaceForMaps(otherMaps, map -> this.removeOrWarn((RecipeMap<?>)map, ((AccessibleRecipeMap)map).findRecipeByOutput(this.EUt, this.outputs, this.fluidOutputs, this.chancedOutputs, this.chancedFluidOutputs), String.format("exact voltage: %s, items: %s, fluids: %s, chanced items: %s, chanced fluids: %s", this.EUt, this.outputs, this.fluidOutputs, this.chancedOutputs, this.chancedFluidOutputs)));
    }

    @Unique
    public R replace(Predicate<Recipe> canHandle, RecipeMap<?> ... otherMaps) {
        return this.replaceForMaps(otherMaps, map -> this.removeOrWarn((RecipeMap<?>)map, ((AccessibleRecipeMap)map).findByOutput(this.outputs, this.fluidOutputs, this.chancedOutputs, this.chancedFluidOutputs, canHandle), String.format("items: %s, fluids: %s, chanced items: %s, chanced fluids: %s", this.outputs, this.fluidOutputs, this.chancedOutputs, this.chancedFluidOutputs)));
    }

    @Unique
    private R replaceForMaps(RecipeMap<?>[] otherMaps, Consumer<RecipeMap<?>> remover) {
        remover.accept(this.recipeMap);
        Arrays.stream(otherMaps).forEach(remover);
        return (R)((RecipeBuilder)this);
    }

    @Unique
    private void removeOrWarn(RecipeMap<?> currMap, @Nullable List<Recipe> foundRecipes, String components) {
        if (foundRecipes == null) {
            if (LabsGroovyHelper.isRunningGroovyScripts()) {
                GroovyLog.msg((String)("Error removing GregTech " + currMap.unlocalizedName + " recipe"), (Object[])new Object[0]).add("could not find recipe for: " + components, new Object[0]).error().post();
            }
            return;
        }
        for (Recipe recipe : foundRecipes) {
            currMap.removeRecipe(recipe);
        }
    }
}

