/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.gregtech;

import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleRecipeMap;
import com.nomiceu.nomilabs.gregtech.mixinhelper.OutputBranch;
import com.nomiceu.nomilabs.gregtech.mixinhelper.RecipeMapLogic;
import com.nomiceu.nomilabs.groovy.RecyclingHelper;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.chance.output.impl.ChancedFluidOutput;
import gregtech.api.recipes.chance.output.impl.ChancedItemOutput;
import gregtech.api.util.ValidationResult;
import gregtech.integration.groovy.VirtualizedRecipeMap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeMap.class}, remap=false)
public abstract class RecipeMapMixin
implements AccessibleRecipeMap {
    @Shadow
    @Final
    private Object grsVirtualizedRecipeMap;
    @Unique
    private final OutputBranch outputLookup = new OutputBranch();

    @Inject(method={"addRecipe"}, at={@At(value="HEAD")}, cancellable=true)
    public void addRecipeInRecycling(@NotNull ValidationResult<Recipe> validationResult, CallbackInfoReturnable<Boolean> cir) {
        if (!RecyclingHelper.isReloadingRecycling()) {
            return;
        }
        if (!Objects.equals(RecyclingHelper.recyclingMaps.get((RecipeMap)this), ((Recipe)validationResult.getResult()).getRecipeCategory())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"removeAllRecipes"}, at={@At(value="HEAD")})
    private void updateOutputLookupClear(CallbackInfo ci) {
        this.outputLookup.clear();
    }

    @Inject(method={"compileRecipe"}, at={@At(value="INVOKE", target="Ljava/util/Map;compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;")})
    private void updateOutputLookupAdd(Recipe recipe, CallbackInfoReturnable<Boolean> cir) {
        RecipeMapLogic.add(recipe, this.outputLookup);
    }

    @Inject(method={"removeRecipe"}, at={@At(value="INVOKE", target="Lgregtech/integration/groovy/GroovyScriptModule;isCurrentlyRunning()Z")})
    private void updateOutputLookupRemove(Recipe recipe, CallbackInfoReturnable<Boolean> cir) {
        RecipeMapLogic.remove(recipe, this.outputLookup);
    }

    @Override
    @Unique
    @Nullable
    public List<Recipe> findByOutput(@NotNull Collection<ItemStack> items, @NotNull Collection<FluidStack> fluids, @NotNull Collection<ChancedItemOutput> chancedItems, @NotNull Collection<ChancedFluidOutput> chancedFluids, @NotNull Predicate<Recipe> canHandle) {
        return RecipeMapLogic.find(this.outputLookup, (RecipeMap)this, items, fluids, chancedItems, chancedFluids, canHandle);
    }

    @Override
    @Unique
    @Nullable
    public List<Recipe> findRecipeByOutput(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids) {
        return this.findRecipeByOutput(voltage, inputs, fluidInputs, chancedItems, chancedFluids, false);
    }

    @Override
    @Unique
    @Nullable
    public List<Recipe> findRecipeByOutput(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids, boolean exactVoltage) {
        List<ItemStack> items = inputs.stream().filter(s -> !s.func_190926_b()).collect(Collectors.toList());
        List<FluidStack> fluids = fluidInputs.stream().filter(f -> f != null && f.amount != 0).collect(Collectors.toList());
        return this.findByOutput(items, fluids, chancedItems, chancedFluids, recipe -> {
            if (exactVoltage && (long)recipe.getEUt() != voltage) {
                return false;
            }
            return (long)recipe.getEUt() <= voltage;
        });
    }

    @Unique
    public VirtualizedRecipeMap getVirtualized() {
        return (VirtualizedRecipeMap)this.grsVirtualizedRecipeMap;
    }
}

