/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.gregtech;

import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleSteamBoiler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.metatileentities.steam.boiler.SteamBoiler;
import gregtech.integration.theoneprobe.provider.SteamBoilerInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SteamBoilerInfoProvider.class}, remap=false)
public class SteamBoilerInfoProviderMixin {
    @Inject(method={"addProbeInfo"}, at={@At(value="HEAD")}, cancellable=true)
    private void replaceProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState state, IProbeHitData data, CallbackInfo ci) {
        ci.cancel();
        if (!state.func_177230_c().hasTileEntity(state)) {
            return;
        }
        TileEntity te = world.func_175625_s(data.getPos());
        if (!(te instanceof IGregTechTileEntity)) {
            return;
        }
        IGregTechTileEntity igtte = (IGregTechTileEntity)te;
        MetaTileEntity mte = igtte.getMetaTileEntity();
        if (!(mte instanceof SteamBoiler)) {
            return;
        }
        SteamBoiler boiler = (SteamBoiler)mte;
        int steamOutput = boiler.getTotalSteamOutput();
        if (steamOutput <= 0 && !boiler.isBurning()) {
            return;
        }
        if (steamOutput > 0 && boiler.hasWater()) {
            probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.energy_production*} " + TextFormatting.AQUA + TextFormattingUtil.formatNumbers((long)(steamOutput / 10)) + TextStyleClass.INFO + " L/t {*" + Materials.Steam.getUnlocalizedName() + "*}");
        }
        if (!boiler.isBurning()) {
            probeInfo.text(TextStyleClass.INFO.toString() + TextFormatting.RED + "{*nomilabs.top.steam_cooling_down*}");
        }
        if (steamOutput <= 0 && ((AccessibleSteamBoiler)boiler).labs$getCurrentTemperature() > 0) {
            probeInfo.text(TextStyleClass.INFO.toString() + TextFormatting.RED + "{*nomilabs.top.steam_heating_up*} " + TextFormattingUtil.formatNumbers((long)((AccessibleSteamBoiler)boiler).labs$getCurrentTemperature()) + "%");
        }
        if (!boiler.hasWater()) {
            probeInfo.text(TextStyleClass.WARNING + "{*gregtech.top.steam_no_water*}");
        }
    }
}

