/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.gregtech;

import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleSteamBoiler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.common.metatileentities.steam.boiler.SteamBoiler;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SteamBoiler.class}, remap=false)
public abstract class SteamBoilerMixin
extends MetaTileEntity
implements AccessibleSteamBoiler {
    @Shadow
    private int currentTemperature;
    @Shadow
    private int fuelMaxBurnTime;
    @Shadow
    private int timeBeforeCoolingDown;
    @Shadow
    private boolean wasBurningAndNeedsUpdate;
    @Shadow
    private int fuelBurnTimeLeft;

    @Shadow
    protected abstract int getCooldownInterval();

    @Shadow
    public abstract int getMaxTemperate();

    public SteamBoilerMixin(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Inject(method={"updateCurrentTemperature"}, at={@At(value="RETURN")})
    private void checkForNegativeBurnTime(CallbackInfo ci) {
        if (this.fuelMaxBurnTime > 0 && this.getOffsetTimer() % 12L == 0L) {
            if (this.fuelBurnTimeLeft < 0) {
                this.fuelMaxBurnTime = 0;
                this.timeBeforeCoolingDown = this.getCooldownInterval();
                this.wasBurningAndNeedsUpdate = true;
            } else if (this.fuelBurnTimeLeft % 2 != 0 && this.currentTemperature < this.getMaxTemperate()) {
                ++this.currentTemperature;
            }
        }
    }

    @Override
    @Unique
    public int labs$getCurrentTemperature() {
        return this.currentTemperature;
    }
}

