/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.gregtech;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleRecipeMap;
import com.nomiceu.nomilabs.groovy.ChangeRecipeBuilder;
import com.nomiceu.nomilabs.groovy.ChangeRecipeBuilderCollection;
import com.nomiceu.nomilabs.groovy.DummyChangeRecipeBuilder;
import com.nomiceu.nomilabs.util.LabsGroovyHelper;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.category.GTRecipeCategory;
import gregtech.api.recipes.chance.output.impl.ChancedFluidOutput;
import gregtech.api.recipes.chance.output.impl.ChancedItemOutput;
import gregtech.integration.groovy.VirtualizedRecipeMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={VirtualizedRecipeMap.class}, remap=false)
public abstract class VirtualizedRecipeMapMixin {
    @Shadow
    @Final
    private RecipeMap<?> recipeMap;

    @Shadow
    public abstract String getName();

    @Shadow
    public abstract Recipe find(long var1, List<ItemStack> var3, List<FluidStack> var4);

    @Unique
    @Nullable
    public Recipe find(List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        return this.find((Recipe r) -> true, inputs, fluidInputs);
    }

    @Unique
    @Nullable
    public Recipe find(GTRecipeCategory category, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        return this.find((Recipe r) -> Objects.equals(category, r.getRecipeCategory()), inputs, fluidInputs);
    }

    @Unique
    public Recipe find(Predicate<Recipe> condition, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        inputs = this.validateList(inputs);
        fluidInputs = this.validateList(fluidInputs);
        List items = inputs.stream().filter(s -> !s.func_190926_b()).collect(Collectors.toList());
        List fluids = fluidInputs.stream().filter(f -> f != null && f.amount != 0).collect(Collectors.toList());
        return this.recipeMap.find(items, fluids, condition);
    }

    @Unique
    public boolean removeByInput(List<ItemStack> items, List<FluidStack> fluids) {
        return this.removeByInput(r -> true, items, fluids, String.format("items: %s, fluids: %s", items, fluids));
    }

    @Unique
    public boolean removeByInput(GTRecipeCategory category, List<ItemStack> items, List<FluidStack> fluids) {
        return this.removeByInput(r -> Objects.equals(r.getRecipeCategory(), category), items, fluids, String.format("category: %s, items %s, fluids %s", category, items, fluids));
    }

    @Unique
    public boolean removeByInput(Predicate<Recipe> condition, List<ItemStack> items, List<FluidStack> fluids) {
        return this.removeByInput(condition, items, fluids, String.format("items: %s, fluids: %s", items, fluids));
    }

    @Unique
    private boolean removeByInput(Predicate<Recipe> condition, List<ItemStack> items, List<FluidStack> fluids, String components) {
        Recipe recipe = this.find(condition, items, fluids);
        if (recipe == null) {
            if (LabsGroovyHelper.isRunningGroovyScripts()) {
                GroovyLog.msg((String)("Error removing GregTech " + this.getName() + " recipe"), (Object[])new Object[0]).add("could not find recipe for: " + components, new Object[0]).error().post();
            }
            return false;
        }
        this.recipeMap.removeRecipe(recipe);
        return true;
    }

    @Unique
    @Nullable
    public List<Recipe> findByOutput(long voltage, List<ItemStack> items, List<FluidStack> fluids) {
        return this.findByOutput(voltage, items, fluids, null, null);
    }

    @Unique
    @Nullable
    public List<Recipe> findByOutput(List<ItemStack> items, List<FluidStack> fluids) {
        return this.findByOutput(items, fluids, null, null);
    }

    @Unique
    @Nullable
    public List<Recipe> findByOutput(GTRecipeCategory category, List<ItemStack> items, List<FluidStack> fluids) {
        return this.findByOutput(category, items, fluids, null, null);
    }

    @Unique
    @Nullable
    public List<Recipe> findByOutput(Predicate<Recipe> condition, List<ItemStack> items, List<FluidStack> fluids) {
        return this.findByOutput(condition, items, fluids, null, null);
    }

    @Unique
    @Nullable
    public List<Recipe> findByOutput(long voltage, List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids) {
        items = this.validateList(items);
        fluids = this.validateList(fluids);
        chancedItems = this.validateList(chancedItems);
        chancedFluids = this.validateList(chancedFluids);
        List<ItemStack> filteredItems = items.stream().filter(s -> !s.func_190926_b()).collect(Collectors.toList());
        List<FluidStack> filteredFluids = fluids.stream().filter(f -> f != null && f.amount != 0).collect(Collectors.toList());
        return this.getAccessibleRecipeMap().findRecipeByOutput(voltage, filteredItems, filteredFluids, chancedItems, chancedFluids);
    }

    @Unique
    @Nullable
    public List<Recipe> findByOutput(List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids) {
        return this.findByOutput((Recipe r) -> true, items, fluids, chancedItems, chancedFluids);
    }

    @Unique
    @Nullable
    public List<Recipe> findByOutput(GTRecipeCategory category, List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids) {
        return this.findByOutput((Recipe r) -> Objects.equals(r.getRecipeCategory(), category), items, fluids, chancedItems, chancedFluids);
    }

    @Unique
    @Nullable
    public List<Recipe> findByOutput(Predicate<Recipe> condition, List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids) {
        items = this.validateList(items);
        fluids = this.validateList(fluids);
        chancedItems = this.validateList(chancedItems);
        chancedFluids = this.validateList(chancedFluids);
        List<ItemStack> filteredItems = items.stream().filter(s -> !s.func_190926_b()).collect(Collectors.toList());
        List<FluidStack> filteredFluids = fluids.stream().filter(f -> f != null && f.amount != 0).collect(Collectors.toList());
        return this.getAccessibleRecipeMap().findByOutput(filteredItems, filteredFluids, chancedItems, chancedFluids, condition);
    }

    @Unique
    public boolean removeByOutput(long voltage, List<ItemStack> items, List<FluidStack> fluids) {
        return this.removeByOutput(voltage, items, fluids, null, null);
    }

    @Unique
    public boolean removeByOutput(List<ItemStack> items, List<FluidStack> fluids) {
        return this.removeByOutput(items, fluids, null, null);
    }

    @Unique
    public boolean removeByOutput(GTRecipeCategory category, List<ItemStack> items, List<FluidStack> fluids) {
        return this.removeByOutput(category, items, fluids, null, null);
    }

    @Unique
    public boolean removeByOutput(Predicate<Recipe> condition, List<ItemStack> items, List<FluidStack> fluids) {
        return this.removeByOutput(condition, items, fluids, null, null);
    }

    @Unique
    public boolean removeByOutput(long voltage, List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids) {
        List<Recipe> recipes = this.findByOutput(voltage, items, fluids, chancedItems, chancedFluids);
        if (recipes == null) {
            if (LabsGroovyHelper.isRunningGroovyScripts()) {
                GroovyLog.msg((String)("Error removing GregTech " + this.getName() + " recipe"), (Object[])new Object[0]).add("could not find recipe for: voltage {}, items: {}, fluids: {}, chanced items: {}, chanced fluids: {}", new Object[]{voltage, items, fluids, chancedItems, chancedFluids}).error().post();
            }
            return false;
        }
        for (Recipe recipe : recipes) {
            this.recipeMap.removeRecipe(recipe);
        }
        return true;
    }

    @Unique
    public boolean removeByOutput(List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids) {
        return this.removeByOutput(r -> true, items, fluids, chancedItems, chancedFluids, String.format("items: %s, fluids: %s, chanced items: %s, chanced fluids: %s", items, fluids, chancedItems, chancedFluids));
    }

    @Unique
    public boolean removeByOutput(GTRecipeCategory category, List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids) {
        return this.removeByOutput(r -> Objects.equals(r.getRecipeCategory(), category), items, fluids, chancedItems, chancedFluids, String.format("category: %s, items: %s, fluids: %s, chanced items: %s, chanced fluids: %s", category, items, fluids, chancedItems, chancedFluids));
    }

    @Unique
    public boolean removeByOutput(Predicate<Recipe> condition, List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids) {
        return this.removeByOutput(condition, items, fluids, chancedItems, chancedFluids, String.format("items: %s, fluids: %s, chanced items: %s, chanced fluids: %s", items, fluids, chancedItems, chancedFluids));
    }

    @Unique
    private boolean removeByOutput(Predicate<Recipe> condition, List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids, String components) {
        List<Recipe> recipes = this.findByOutput(condition, items, fluids, chancedItems, chancedFluids);
        if (recipes == null) {
            if (LabsGroovyHelper.isRunningGroovyScripts()) {
                GroovyLog.msg((String)("Error removing GregTech " + this.getName() + " recipes by output"), (Object[])new Object[0]).add("could not find recipe for: " + components, new Object[0]).error().post();
            }
            return false;
        }
        for (Recipe recipe : recipes) {
            this.recipeMap.removeRecipe(recipe);
        }
        return true;
    }

    @Unique
    public ChangeRecipeBuilder<?> changeByInput(long voltage, List<ItemStack> items, List<FluidStack> fluids) {
        Recipe recipe = this.find(voltage, items, fluids);
        if (recipe == null) {
            if (LabsGroovyHelper.isRunningGroovyScripts()) {
                GroovyLog.msg((String)("Error changing GregTech " + this.getName() + " recipe"), (Object[])new Object[0]).add("could not find recipe for: voltage {}, items {}, fluids {}", new Object[]{voltage, items, fluids}).error().post();
            }
            return new DummyChangeRecipeBuilder(this.recipeMap);
        }
        return new ChangeRecipeBuilder(recipe, this.recipeMap);
    }

    @Unique
    public ChangeRecipeBuilder<?> changeByInput(List<ItemStack> items, List<FluidStack> fluids) {
        return this.changeByInput(r -> true, items, fluids, String.format("items: %s, fluids: %s", items, fluids));
    }

    @Unique
    public ChangeRecipeBuilder<?> changeByInput(GTRecipeCategory category, List<ItemStack> items, List<FluidStack> fluids) {
        return this.changeByInput(r -> Objects.equals(r.getRecipeCategory(), category), items, fluids, String.format("category: %s, items %s, fluids %s", category, items, fluids));
    }

    @Unique
    public ChangeRecipeBuilder<?> changeByInput(Predicate<Recipe> condition, List<ItemStack> items, List<FluidStack> fluids) {
        return this.changeByInput(condition, items, fluids, String.format("items: %s, fluids: %s", items, fluids));
    }

    @Unique
    private ChangeRecipeBuilder<?> changeByInput(Predicate<Recipe> condition, List<ItemStack> items, List<FluidStack> fluids, String components) {
        Recipe recipe = this.find(condition, items, fluids);
        if (recipe == null) {
            if (LabsGroovyHelper.isRunningGroovyScripts()) {
                GroovyLog.msg((String)("Error changing GregTech " + this.getName() + " recipe"), (Object[])new Object[0]).add("could not find recipe for: " + components, new Object[0]).error().post();
            }
            return new DummyChangeRecipeBuilder(this.recipeMap);
        }
        return new ChangeRecipeBuilder(recipe, this.recipeMap);
    }

    @Unique
    public ChangeRecipeBuilderCollection<?> changeByOutput(long voltage, List<ItemStack> items, List<FluidStack> fluids) {
        return this.changeByOutput(voltage, items, fluids, null, null);
    }

    @Unique
    public ChangeRecipeBuilderCollection<?> changeByOutput(List<ItemStack> items, List<FluidStack> fluids) {
        return this.changeByOutput(items, fluids, null, null);
    }

    @Unique
    public ChangeRecipeBuilderCollection<?> changeByOutput(GTRecipeCategory category, List<ItemStack> items, List<FluidStack> fluids) {
        return this.changeByOutput(category, items, fluids, null, null);
    }

    @Unique
    public ChangeRecipeBuilderCollection<?> changeByOutput(Predicate<Recipe> condition, List<ItemStack> items, List<FluidStack> fluids) {
        return this.changeByOutput(condition, items, fluids, null, null);
    }

    @Unique
    public ChangeRecipeBuilderCollection<?> changeByOutput(long voltage, List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids) {
        List<Recipe> recipes = this.findByOutput(voltage, items, fluids, chancedItems, chancedFluids);
        if (recipes == null) {
            if (LabsGroovyHelper.isRunningGroovyScripts()) {
                GroovyLog.msg((String)("Error changing GregTech " + this.getName() + " recipe"), (Object[])new Object[0]).add("could not find recipe for: voltage {}, items: {}, fluids: {}, chanced items: {}, chanced fluids: {}", new Object[]{voltage, items, fluids, chancedItems, chancedFluids}).error().post();
            }
            return new ChangeRecipeBuilderCollection();
        }
        return ChangeRecipeBuilderCollection.fromStream(recipes.stream().map(r -> new ChangeRecipeBuilder((Recipe)r, this.recipeMap)));
    }

    @Unique
    public ChangeRecipeBuilderCollection<?> changeByOutput(List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids) {
        return this.changeByOutput(r -> true, items, fluids, chancedItems, chancedFluids, String.format("items: %s, fluids: %s, chanced items: %s, chanced fluids: %s", items, fluids, chancedItems, chancedFluids));
    }

    @Unique
    public ChangeRecipeBuilderCollection<?> changeByOutput(GTRecipeCategory category, List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids) {
        return this.changeByOutput(r -> Objects.equals(r.getRecipeCategory(), category), items, fluids, chancedItems, chancedFluids, String.format("category: %s, items: %s, fluids: %s, chanced items: %s, chanced fluids: %s", category, items, fluids, chancedItems, chancedFluids));
    }

    @Unique
    public ChangeRecipeBuilderCollection<?> changeByOutput(Predicate<Recipe> condition, List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids) {
        return this.changeByOutput(condition, items, fluids, chancedItems, chancedFluids, String.format("items: %s, fluids: %s, chanced items: %s, chanced fluids: %s", items, fluids, chancedItems, chancedFluids));
    }

    @Unique
    private ChangeRecipeBuilderCollection<?> changeByOutput(Predicate<Recipe> condition, List<ItemStack> items, List<FluidStack> fluids, List<ChancedItemOutput> chancedItems, List<ChancedFluidOutput> chancedFluids, String components) {
        List<Recipe> recipes = this.findByOutput(condition, items, fluids, chancedItems, chancedFluids);
        if (recipes == null) {
            if (LabsGroovyHelper.isRunningGroovyScripts()) {
                GroovyLog.msg((String)("Error changing GregTech " + this.getName() + " recipes by output"), (Object[])new Object[0]).add("could not find recipe for: " + components, new Object[0]).error().post();
            }
            return new ChangeRecipeBuilderCollection();
        }
        return ChangeRecipeBuilderCollection.fromStream(recipes.stream().map(r -> new ChangeRecipeBuilder((Recipe)r, this.recipeMap)));
    }

    @Unique
    public ChangeRecipeBuilderCollection<?> changeAllRecipes() {
        return this.changeAllRecipes((Recipe r) -> true);
    }

    @Unique
    public ChangeRecipeBuilderCollection<?> changeAllRecipes(Predicate<Recipe> condition) {
        return ChangeRecipeBuilderCollection.fromStream(this.recipeMap.getRecipeList().stream().filter(condition).map(r -> new ChangeRecipeBuilder((Recipe)r, this.recipeMap)));
    }

    @Unique
    public ChangeRecipeBuilderCollection<?> changeAllRecipes(GTRecipeCategory category) {
        return this.changeAllRecipes(category, r -> true);
    }

    @Unique
    public ChangeRecipeBuilderCollection<?> changeAllRecipes(GTRecipeCategory category, Predicate<Recipe> condition) {
        return ChangeRecipeBuilderCollection.fromStream(((List)this.recipeMap.getRecipesByCategory().getOrDefault(category, new ArrayList())).stream().filter(condition).map(r -> new ChangeRecipeBuilder((Recipe)r, this.recipeMap)));
    }

    @Unique
    private AccessibleRecipeMap getAccessibleRecipeMap() {
        return (AccessibleRecipeMap)this.recipeMap;
    }

    @Unique
    @NotNull
    private <T> List<T> validateList(@Nullable List<T> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }
}

