/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.gregtech;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.gregtech.mixinhelper.OreData;
import gregtech.api.unification.OreDictUnifier;
import gregtech.common.terminal.app.prospector.ProspectingTexture;
import gregtech.common.terminal.app.prospector.ProspectorMode;
import gregtech.common.terminal.app.prospector.widget.WidgetOreList;
import gregtech.common.terminal.app.prospector.widget.WidgetProspectingMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.multiplayer.WorldClient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={WidgetProspectingMap.class}, remap=false)
public class WidgetProspectingMapMixin {
    @Shadow
    private ProspectingTexture texture;
    @Shadow
    private boolean darkMode;
    @Unique
    private OreData labs$hoveredOreData = null;
    @Unique
    private Map<String, OreData> labs$nameToData = new Object2ObjectOpenHashMap();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void defaultDark(int xPosition, int yPosition, int chunkRadius, WidgetOreList widgetOreList, ProspectorMode mode, int scanTick, CallbackInfo ci) {
        this.darkMode = LabsConfig.modIntegration.defaultDarkMode;
    }

    @Inject(method={"drawInForeground"}, at={@At(value="HEAD")})
    private void resetLabsData(int mouseX, int mouseY, CallbackInfo ci) {
        this.labs$hoveredOreData = null;
        this.labs$nameToData.clear();
    }

    @Inject(method={"drawInForeground"}, at={@At(value="INVOKE", target="Ljava/util/HashMap;forEach(Ljava/util/function/BiConsumer;)V")}, require=1, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void initLabsData(int mouseX, int mouseY, CallbackInfo ci, @Local(ordinal=2) int cX, @Local(ordinal=3) int cZ) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (this.texture.map[cX * 16 + i][cZ * 16 + j] == null) continue;
                this.texture.map[cX * 16 + i][cZ * 16 + j].entrySet().forEach(entry -> {
                    String name = OreDictUnifier.get((String)((String)entry.getValue())).func_82833_r();
                    if (!"[all]".equals(this.texture.getSelected()) && !this.texture.getSelected().equals(entry.getValue())) {
                        return;
                    }
                    OreData nameData = this.labs$nameToData.get(name);
                    if (nameData == null) {
                        this.labs$nameToData.put(name, new OreData((Byte)entry.getKey()));
                    } else {
                        nameData.update((Byte)entry.getKey());
                    }
                    if (this.labs$hoveredOreData == null) {
                        this.labs$hoveredOreData = new OreData((Byte)entry.getKey());
                    } else {
                        this.labs$hoveredOreData.update((Byte)entry.getKey());
                    }
                });
            }
        }
    }

    @Redirect(method={"drawInForeground"}, at=@At(value="INVOKE", target="Ljava/util/HashMap;forEach(Ljava/util/function/BiConsumer;)V"), require=1)
    private void sortTooltipsByY(HashMap<String, Integer> instance, BiConsumer<String, Integer> biConsumer) {
        instance.entrySet().stream().sorted((a, b) -> {
            OreData dataA = this.labs$nameToData.get(a.getKey());
            OreData dataB = this.labs$nameToData.get(b.getKey());
            if (dataA == null || dataB == null) {
                return ((String)a.getKey()).compareTo((String)b.getKey());
            }
            return Byte.compare(dataB.minY(), dataA.minY());
        }).forEach(entry -> biConsumer.accept((String)entry.getKey(), (Integer)entry.getValue()));
    }

    @Redirect(method={"lambda$drawInForeground$2"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=0), require=1)
    private <E> boolean addYDataToTooltips(List<E> instance, E e) {
        if (!(e instanceof String)) {
            NomiLabs.LOGGER.error("[ProspectorMixin] Bad Injection!");
            return instance.add((String)e);
        }
        String str = (String)e;
        String[] splitStr = str.split(" --- ");
        OreData data = this.labs$nameToData.get(splitStr[0]);
        if (data == null) {
            NomiLabs.LOGGER.error("[ProspectorMixin] Could not find Y data for name {}!", (Object)splitStr[0]);
            return instance.add((String)e);
        }
        return instance.add(String.format("%s --- \u00a7e%s\u00a7r (y: \u00a7c%s - %s\u00a7r)", splitStr[0], splitStr[1], data.minY(), data.maxY()));
    }

    @WrapOperation(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/WorldClient;getHeight(II)I", remap=true)}, require=1, remap=false)
    private int useHoveredOreHeightMain(WorldClient instance, int x, int z, Operation<Integer> original) {
        if (this.labs$hoveredOreData == null) {
            return (Integer)original.call(new Object[]{instance, x, z});
        }
        return this.labs$hoveredOreData.avgY();
    }

    @WrapOperation(method={"addVoxelMapWaypoint"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/WorldClient;getHeight(II)I", remap=true)}, require=1, remap=false)
    private int useHoveredOreHeightVoxel(WorldClient instance, int x, int z, Operation<Integer> original) {
        if (this.labs$hoveredOreData == null) {
            return (Integer)original.call(new Object[]{instance, x, z});
        }
        return this.labs$hoveredOreData.avgY();
    }

    @WrapOperation(method={"addXaeroMapWaypoint"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/WorldClient;getHeight(II)I", remap=true)}, require=1, remap=false)
    private int useHoveredOreHeightXaero(WorldClient instance, int x, int z, Operation<Integer> original) {
        if (this.labs$hoveredOreData == null) {
            return (Integer)original.call(new Object[]{instance, x, z});
        }
        return this.labs$hoveredOreData.avgY();
    }
}

