/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.groovyscript;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.compat.vanilla.CraftingRecipeBuilder;
import com.cleanroommc.groovyscript.registry.AbstractCraftingRecipeBuilder;
import com.nomiceu.nomilabs.groovy.mixinhelper.RecipeTooltipAdder;
import com.nomiceu.nomilabs.groovy.mixinhelper.StrictableRecipe;
import com.nomiceu.nomilabs.util.LabsTranslate;
import net.minecraft.item.crafting.IRecipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftingRecipeBuilder.Shapeless.class}, remap=false)
public abstract class ShapelessRecipeBuilderMixin
extends AbstractCraftingRecipeBuilder.AbstractShapeless<IRecipe> {
    @Unique
    private boolean labs$isStrict = false;
    @Unique
    private LabsTranslate.Translatable[][] labs$inputTooltip = null;
    @Unique
    private LabsTranslate.Translatable[] labs$outputTooltip = null;

    private ShapelessRecipeBuilderMixin(int width, int height) {
        super(width, height);
    }

    @Unique
    public CraftingRecipeBuilder.Shapeless strictJEIHandling() {
        this.labs$isStrict = true;
        return (CraftingRecipeBuilder.Shapeless)this;
    }

    @Unique
    public CraftingRecipeBuilder.Shapeless setOutputTooltip(LabsTranslate.Translatable ... tooltip) {
        this.labs$outputTooltip = tooltip;
        return (CraftingRecipeBuilder.Shapeless)this;
    }

    @Unique
    public CraftingRecipeBuilder.Shapeless setInputTooltip(int slotIndex, LabsTranslate.Translatable ... tooltip) {
        if (slotIndex < 0 || slotIndex > 8) {
            GroovyLog.get().error((Object)"Add Recipe Input Tooltip: Slot Index must be between 0 and 8!");
            return (CraftingRecipeBuilder.Shapeless)this;
        }
        if (this.labs$inputTooltip == null) {
            this.labs$inputTooltip = new LabsTranslate.Translatable[9][0];
        }
        this.labs$inputTooltip[slotIndex] = tooltip;
        return (CraftingRecipeBuilder.Shapeless)this;
    }

    @Unique
    public CraftingRecipeBuilder.Shapeless setInputTooltip(LabsTranslate.Translatable ... tooltip) {
        for (int i = 0; i < 9; ++i) {
            this.setInputTooltip(i, tooltip);
        }
        return (CraftingRecipeBuilder.Shapeless)this;
    }

    @Inject(method={"register()Lnet/minecraft/item/crafting/IRecipe;"}, at={@At(value="RETURN")})
    private void setStrict(CallbackInfoReturnable<IRecipe> cir) {
        IRecipe val = (IRecipe)cir.getReturnValue();
        if (!(val instanceof StrictableRecipe)) {
            return;
        }
        StrictableRecipe strict = (StrictableRecipe)val;
        if (this.labs$isStrict) {
            strict.labs$setStrict();
        }
    }

    @Inject(method={"register()Lnet/minecraft/item/crafting/IRecipe;"}, at={@At(value="TAIL")})
    private void addRecipeTooltips(CallbackInfoReturnable<IRecipe> cir) {
        RecipeTooltipAdder.addTooltips(this.name, this.labs$inputTooltip, this.labs$outputTooltip);
    }
}

