/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.jei;

import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.integration.jei.LabsJEIPlugin;
import com.nomiceu.nomilabs.util.LabsSide;
import java.util.List;
import mezz.jei.plugins.vanilla.crafting.CraftingRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CraftingRecipeCategory.class}, remap=false)
public class CraftingRecipeCategoryMixin {
    @Shadow
    @Final
    private static int craftOutputSlot;
    @Shadow
    @Final
    private static int craftInputSlot1;

    @Inject(method={"lambda$setRecipe$0"}, at={@At(value="HEAD")})
    private static void addRecipeIngredientTooltips(ResourceLocation registryName, int slotIndex, boolean input, ItemStack stack, List<String> tooltip, CallbackInfo ci) {
        if (LabsSide.isServer()) {
            return;
        }
        if (slotIndex != craftOutputSlot) {
            int index = slotIndex - craftInputSlot1;
            if (index < 0 || index > 8) {
                return;
            }
            List<String> inputTooltip = LabsJEIPlugin.getRecipeInputTooltip(registryName, index);
            if (LabsConfig.modIntegration.addJEIIngEmptyLine && !inputTooltip.isEmpty()) {
                tooltip.add("");
            }
            tooltip.addAll(inputTooltip);
            return;
        }
        boolean modIdDifferent = false;
        ResourceLocation itemRegistryName = stack.func_77973_b().getRegistryName();
        if (itemRegistryName != null) {
            String itemModId = itemRegistryName.func_110624_b();
            modIdDifferent = !registryName.func_110624_b().equals(itemModId);
        }
        boolean showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || GuiScreen.func_146272_n();
        List<String> outputTooltip = LabsJEIPlugin.getRecipeOutputTooltip(registryName);
        if (LabsConfig.modIntegration.addJEIIngEmptyLine && (modIdDifferent || showAdvanced || !outputTooltip.isEmpty())) {
            tooltip.add("");
        }
        tooltip.addAll(outputTooltip);
    }
}

