/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.jei;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.plugins.jei.info.IngredientInfoRecipe;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IngredientInfoRecipe.class}, remap=false)
public class IngredientInfoRecipeMixin<T> {
    @Shadow
    @Mutable
    @Final
    private List<String> description;

    @Redirect(method={"create"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"), require=1)
    private static <E> boolean addRecipeIfValid(List<E> instance, E e) {
        IngredientInfoRecipe ing;
        if (e instanceof IngredientInfoRecipe && !(ing = (IngredientInfoRecipe)e).getDescription().isEmpty()) {
            return instance.add(e);
        }
        return true;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void trimDescription(IGuiHelper guiHelper, List<T> ingredients, IIngredientType<T> ingredientType, List<String> inDescription, CallbackInfo ci) {
        int toRemove = 0;
        for (String line : this.description) {
            if (!IngredientInfoRecipeMixin.removeFormattingAndTrim(line).isEmpty()) break;
            ++toRemove;
        }
        if (toRemove == this.description.size()) {
            this.description.clear();
        } else if (toRemove != 0) {
            this.description = this.description.subList(toRemove, this.description.size());
        }
    }

    @Unique
    private static String removeFormattingAndTrim(String input) {
        String output = TextFormatting.func_110646_a((String)input.trim());
        if (output == null) {
            return "";
        }
        return output;
    }
}

