/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.nuclearcraft;

import java.util.List;
import nc.config.NCConfig;
import nc.network.tile.FissionUpdatePacket;
import nc.recipe.ProcessorRecipeHandler;
import nc.tile.IGui;
import nc.tile.generator.TileFissionController;
import nc.tile.generator.TileItemGenerator;
import nc.tile.internal.inventory.ItemSorption;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TileFissionController.class}, remap=false)
public abstract class TileFissionControllerMixin
extends TileItemGenerator
implements IGui<FissionUpdatePacket> {
    @Shadow
    public double heat;
    @Shadow
    public double heatChange;
    @Shadow
    public double cooling;
    @Shadow
    public int comparatorStrength;
    @Unique
    private boolean labs$prevProcessing = false;

    @Shadow
    public abstract int getMaxHeat();

    @Shadow
    public abstract boolean isProcessing();

    @Shadow
    public abstract int getComparatorStrength();

    @Shadow
    public abstract boolean findAdjacentComparator();

    private TileFissionControllerMixin(String name, int itemInSize, int itemOutSize, int otherSize, @NotNull List<ItemSorption> itemSorptions, int capacity, @NotNull ProcessorRecipeHandler recipeHandler) {
        super(name, itemInSize, itemOutSize, otherSize, itemSorptions, capacity, recipeHandler);
    }

    @Inject(method={"updateGenerator"}, at={@At(value="HEAD")})
    private void saveProcessing(CallbackInfo ci) {
        this.labs$prevProcessing = this.isProcessing();
    }

    @Inject(method={"overheat"}, at={@At(value="RETURN")}, cancellable=true)
    private void properOverheatReturn(CallbackInfoReturnable<Boolean> cir) {
        int compStrength;
        if (this.heat < (double)this.getMaxHeat() || NCConfig.fission_overheat) {
            return;
        }
        cir.setReturnValue((Object)true);
        this.getRadiationSource().setRadiationLevel(0.0);
        boolean processing = this.isProcessing();
        this.heat = Math.max(0.0, this.heat - this.heatChange + this.cooling);
        boolean shouldUpdate = false;
        if (this.labs$prevProcessing != processing) {
            shouldUpdate = true;
            this.updateBlockType();
            this.sendUpdateToAllPlayers();
        }
        if (this.comparatorStrength != (compStrength = this.getComparatorStrength()) && this.findAdjacentComparator()) {
            shouldUpdate = true;
        }
        this.comparatorStrength = compStrength;
        this.sendUpdateToListeningPlayers();
        if (shouldUpdate) {
            this.func_70296_d();
        }
    }
}

