/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.solarflux;

import com.google.common.math.LongMath;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.integration.solarflux.AccessibleInventoryDummy;
import com.nomiceu.nomilabs.integration.solarflux.AccessibleTileBaseSolar;
import gregtech.api.GTValues;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tk.zeitheron.solarflux.api.SolarInstance;
import tk.zeitheron.solarflux.api.attribute.SimpleAttributeProperty;
import tk.zeitheron.solarflux.block.tile.TileBaseSolar;
import tk.zeitheron.solarflux.gui.ContainerBaseSolar;
import tk.zeitheron.solarflux.items.ItemUpgrade;
import tk.zeitheron.solarflux.utils.BlockPosFace;
import tk.zeitheron.solarflux.utils.InventoryDummy;

@Mixin(value={TileBaseSolar.class}, remap=false)
public abstract class TileBaseSolarMixin
extends TileEntity
implements AccessibleTileBaseSolar {
    @Shadow
    public long energy;
    @Shadow
    @Final
    public SimpleAttributeProperty transfer;
    @Shadow
    public SolarInstance instance;
    @Shadow
    @Final
    public List<BlockPosFace> traversal;
    @Shadow
    @Final
    public SimpleAttributeProperty capacity;
    @Shadow
    public List<EntityPlayer> crafters;
    @Shadow
    public long currentGeneration;
    @Shadow
    @Final
    public InventoryDummy chargeInventory;
    @Shadow
    @Final
    public SimpleAttributeProperty generation;
    @Shadow
    @Final
    public InventoryDummy upgradeInventory;
    @Unique
    private final Set<EnumFacing> labs$blacklisted = new ObjectOpenHashSet(4);
    @Unique
    private final Map<ResourceLocation, Pair<ItemStack, Integer>> labs$tickedUpgrades = new Object2ObjectOpenHashMap(5);
    @Unique
    private IEnergyStorage labs$chargerEnergy = null;
    @Unique
    private final int labs$offset = GTValues.RNG.nextInt(20);
    @Unique
    private long labs$timer = 0L;
    @Unique
    private TileEntity[] labs$teCache;
    @Unique
    private AccessibleTileBaseSolar[] labs$solarCache;
    @Unique
    private boolean labs$lastBalanceSuccess = true;
    @Unique
    private int labs$extraBalancing = 0;
    @Unique
    private boolean[] labs$excludePosUpdate = null;

    @Shadow
    public abstract int getEnergyStored();

    @Shadow
    public abstract int getGeneration();

    @Override
    @Unique
    public void labs$addBlacklistSide(EnumFacing side) {
        this.labs$blacklisted.add(side);
    }

    @Override
    @Unique
    public long labs$rawEnergy() {
        return this.energy;
    }

    @Override
    @Unique
    public void labs$setEnergy(long amt) {
        this.energy = amt;
    }

    @Inject(method={"update"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;getTotalWorldTime()J")}, require=1, remap=true, cancellable=true)
    private void replaceEnergyHandlingLogic(CallbackInfo ci) {
        ci.cancel();
        this.capacity.setBaseValue((double)this.instance.cap);
        this.transfer.setBaseValue((double)this.instance.transfer);
        if (!this.traversal.isEmpty() && this.field_145850_b.func_72820_D() % 20L == 0L) {
            this.traversal.clear();
        }
        this.currentGeneration = this.getGeneration();
        this.labs$buildExclusionCache();
        this.labs$tickChargerAndUpgrades();
        this.energy = Math.min(this.energy + this.currentGeneration, this.capacity.getValueL());
        for (int i = 0; i < this.crafters.size(); ++i) {
            try {
                EntityPlayer player = this.crafters.get(i);
                if (player.field_71070_bA instanceof ContainerBaseSolar) {
                    player.field_71070_bA.func_75142_b();
                    continue;
                }
                this.crafters.remove(i);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.labs$buildTeCache();
        if (this.labs$timer == 0L || (this.labs$timer + (long)this.labs$offset) % (long)TileBaseSolarMixin.labs$getCfg().autoBalancingFrequency == 0L) {
            this.labs$lastBalanceSuccess = this.labs$autoBalanceEnergy(true);
        }
        this.labs$autoPushEnergy();
        ++this.labs$timer;
    }

    @Unique
    private void labs$buildExclusionCache() {
        if (this.labs$excludePosUpdate != null) {
            return;
        }
        this.labs$excludePosUpdate = new boolean[6];
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (side == EnumFacing.UP) {
                this.labs$excludePosUpdate[side.ordinal()] = true;
                continue;
            }
            BlockPos offset = this.field_174879_c.func_177972_a(side);
            if ((side != EnumFacing.DOWN || offset.func_177956_o() >= 0) && this.field_145850_b.func_175723_af().func_177746_a(offset)) continue;
            this.labs$excludePosUpdate[side.ordinal()] = true;
        }
    }

    @Unique
    private void labs$buildTeCache() {
        this.labs$teCache = new TileEntity[6];
        this.labs$solarCache = new AccessibleTileBaseSolar[4];
        for (EnumFacing side : EnumFacing.field_82609_l) {
            IBlockState state;
            BlockPos offset;
            if (this.labs$excludePosUpdate[side.ordinal()] || this.labs$blacklisted.contains(side) || !this.field_145850_b.func_175667_e(offset = this.field_174879_c.func_177972_a(side)) || (state = this.field_145850_b.func_175726_f(offset).func_177435_g(offset)).func_177230_c() == Blocks.field_150350_a) continue;
            TileEntity te = this.field_145850_b.func_175625_s(offset);
            if (te instanceof AccessibleTileBaseSolar) {
                AccessibleTileBaseSolar solar = (AccessibleTileBaseSolar)te;
                if (side == EnumFacing.DOWN) continue;
                this.labs$solarCache[side.func_176736_b()] = solar;
                continue;
            }
            this.labs$teCache[side.ordinal()] = te;
        }
        this.labs$blacklisted.clear();
    }

    @Unique
    private void labs$tickChargerAndUpgrades() {
        if (((AccessibleInventoryDummy)this.upgradeInventory).labs$stateChanged() || this.labs$timer == 0L) {
            this.labs$updateUpgrades();
        }
        this.labs$resetAttributes();
        this.labs$tickCharger();
    }

    @Unique
    private void labs$updateUpgrades() {
        this.labs$tickedUpgrades.clear();
        for (int i = 0; i < this.upgradeInventory.func_70302_i_(); ++i) {
            ItemUpgrade upgrade;
            ItemStack stack = this.upgradeInventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (item instanceof ItemUpgrade && (upgrade = (ItemUpgrade)item).canStayInPanel(this.labs$getThis(), stack, this.upgradeInventory)) {
                ResourceLocation id = stack.func_77973_b().getRegistryName();
                if (!this.labs$tickedUpgrades.containsKey(id)) {
                    this.labs$tickedUpgrades.put(id, (Pair<ItemStack, Integer>)Pair.of((Object)stack, (Object)stack.func_190916_E()));
                    continue;
                }
                Pair<ItemStack, Integer> pair = this.labs$tickedUpgrades.get(id);
                pair.setValue((Object)((Integer)pair.getValue() + stack.func_190916_E()));
                continue;
            }
            this.upgradeInventory.func_70299_a(i, ItemStack.field_190927_a);
            Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)stack);
        }
    }

    @Unique
    private void labs$resetAttributes() {
        this.generation.clearAttributes();
        this.transfer.clearAttributes();
        this.capacity.clearAttributes();
        for (Pair<ItemStack, Integer> pair : this.labs$tickedUpgrades.values()) {
            ItemUpgrade upgrade = (ItemUpgrade)((ItemStack)pair.getKey()).func_77973_b();
            upgrade.update(this.labs$getThis(), (ItemStack)pair.getKey(), ((Integer)pair.getValue()).intValue());
        }
    }

    @Unique
    private void labs$tickCharger() {
        if (((AccessibleInventoryDummy)this.chargeInventory).labs$stateChanged() || this.labs$timer == 0L) {
            this.labs$chargerEnergy = null;
            ItemStack stack = this.chargeInventory.func_70301_a(0);
            if (stack.func_190926_b()) {
                return;
            }
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (storage == null || !storage.canReceive() || storage.getEnergyStored() >= storage.getMaxEnergyStored()) {
                return;
            }
            this.labs$chargerEnergy = storage;
        } else if (this.labs$chargerEnergy == null) {
            return;
        }
        if (!this.labs$chargerEnergy.canReceive() || this.labs$chargerEnergy.getEnergyStored() >= this.labs$chargerEnergy.getMaxEnergyStored()) {
            this.labs$chargerEnergy = null;
            return;
        }
        this.energy -= (long)this.labs$chargerEnergy.receiveEnergy(Math.min(this.getEnergyStored(), this.transfer.getValueI()), false);
    }

    @Unique
    private boolean labs$autoBalanceEnergy(boolean blacklist) {
        EnumFacing maxSide = null;
        long maxDelta = 0L;
        long maxAbsDelta = 0L;
        for (EnumFacing side : EnumFacing.field_176754_o) {
            long delta;
            long absDelta;
            long rawEnergy;
            if (this.labs$solarCache[side.func_176736_b()] == null || this.energy == (rawEnergy = this.labs$solarCache[side.func_176736_b()].labs$rawEnergy()) || (absDelta = Math.abs(delta = LongMath.saturatedSubtract((long)this.energy, (long)rawEnergy))) <= maxAbsDelta) continue;
            maxSide = side;
            maxDelta = delta;
            maxAbsDelta = absDelta;
        }
        if (maxSide == null) {
            return false;
        }
        this.labs$autoBalanceSide(maxSide, maxDelta, maxAbsDelta, this.labs$solarCache[maxSide.func_176736_b()], blacklist);
        return true;
    }

    @Unique
    private void labs$autoBalanceSide(EnumFacing side, long delta, long absDelta, AccessibleTileBaseSolar solar, boolean blacklist) {
        if (blacklist) {
            solar.labs$addBlacklistSide(side.func_176734_d());
        }
        long avg = LongMath.mean((long)this.energy, (long)solar.labs$rawEnergy());
        long energyHere = avg + (delta & 1L);
        long energyThere = avg;
        if (this.currentGeneration > 0L && (float)absDelta > (float)this.currentGeneration * 0.75f) {
            long extraEnergy = (float)absDelta > (float)this.transfer.getValueI() * 0.75f ? (long)this.transfer.getValueI() : this.currentGeneration;
            extraEnergy = Math.min(extraEnergy, avg);
            if (delta > 0L) {
                energyHere -= extraEnergy;
                energyThere += extraEnergy;
            } else {
                energyHere += extraEnergy;
                energyThere -= extraEnergy;
            }
        }
        if (energyHere > (long)this.capacity.getValueI()) {
            energyThere += energyHere - (long)this.capacity.getValueI();
        } else if (energyThere > (long)this.capacity.getValueI()) {
            energyHere += energyThere - (long)this.capacity.getValueI();
        }
        this.labs$setEnergy(energyHere);
        solar.labs$setEnergy(energyThere);
    }

    @Unique
    private void labs$autoPushEnergy() {
        this.labs$extraBalancing = 0;
        for (int i = 0; i < this.labs$teCache.length; ++i) {
            this.labs$autoPushTo(this.labs$teCache[i], EnumFacing.func_82600_a((int)i).func_176734_d());
        }
        if (!this.traversal.isEmpty()) {
            for (BlockPosFace traverse : this.traversal) {
                this.labs$autoPushTo(this.field_145850_b.func_175625_s(traverse.pos), traverse.face);
            }
        }
    }

    @Unique
    private void labs$autoPushTo(TileEntity te, EnumFacing side) {
        int max;
        if (te == null) {
            return;
        }
        if (!te.hasCapability(CapabilityEnergy.ENERGY, side)) {
            return;
        }
        IEnergyStorage storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, side);
        if (storage == null || !storage.canReceive()) {
            return;
        }
        int stored = this.getEnergyStored();
        if (stored >= (max = this.transfer.getValueI()) || !this.labs$lastBalanceSuccess || !TileBaseSolarMixin.labs$getCfg().extraBalancing || this.labs$extraBalancing >= TileBaseSolarMixin.labs$getCfg().extraBalancingAmount) {
            this.energy -= (long)storage.receiveEnergy(Math.min(stored, max), false);
            return;
        }
        if (stored >= (max = Math.min(max, storage.receiveEnergy(max, true)))) {
            this.energy -= (long)storage.receiveEnergy(max, false);
            return;
        }
        stored = this.labs$autoPushBalance(max);
        this.energy -= (long)storage.receiveEnergy(Math.min(stored, max), false);
    }

    @Unique
    private int labs$autoPushBalance(int target) {
        long currEnergy;
        for (currEnergy = this.energy; currEnergy < (long)target && this.labs$extraBalancing < TileBaseSolarMixin.labs$getCfg().extraBalancingAmount; currEnergy += this.energy) {
            this.energy = 0L;
            this.labs$lastBalanceSuccess = this.labs$autoBalanceEnergy(false);
            if (!this.labs$lastBalanceSuccess) break;
            ++this.labs$extraBalancing;
        }
        this.energy = currEnergy;
        return this.getEnergyStored();
    }

    @Unique
    private TileBaseSolar labs$getThis() {
        return (TileBaseSolar)this;
    }

    @Unique
    private static LabsConfig.ModIntegration.SolarFluxPerformanceOptions labs$getCfg() {
        return LabsConfig.modIntegration.solarFluxPerformanceOptions;
    }
}

