/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.theoneprobe;

import com.nomiceu.nomilabs.integration.top.LabsFluidNameElement;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeConfig;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoProvider;
import mcjty.theoneprobe.config.Config;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DefaultProbeInfoProvider.class}, remap=false)
public class DefaultProbeInfoProviderMixin {
    @Inject(method={"addFluidInfo"}, at={@At(value="HEAD")}, cancellable=true)
    private void showTranslatedFluidInfo(IProbeInfo probeInfo, ProbeConfig config, FluidStack fluidStack, int maxContents, CallbackInfo ci) {
        int contents;
        int n = contents = fluidStack == null ? 0 : fluidStack.amount;
        if (fluidStack != null) {
            probeInfo.element((IElement)new LabsFluidNameElement(fluidStack, true));
        }
        if (config.getTankMode() == 1) {
            probeInfo.progress(contents, maxContents, probeInfo.defaultProgressStyle().suffix("mB").filledColor(Config.tankbarFilledColor).alternateFilledColor(Config.tankbarAlternateFilledColor).borderColor(Config.tankbarBorderColor).numberFormat(Config.tankFormat));
        } else {
            probeInfo.text(TextStyleClass.PROGRESS + ElementProgress.format((long)contents, (NumberFormat)Config.tankFormat, (String)"mB"));
        }
        ci.cancel();
    }
}

