/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.theoneprobe;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.nomiceu.nomilabs.config.LabsConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.apiimpl.providers.HarvestInfoTools;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HarvestInfoTools.class}, remap=false)
public class HarvestInfoToolsMixin {
    @Shadow
    @Final
    private static HashMap<String, ItemStack> testTools;

    @Inject(method={"showHarvestInfo"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/block/Block;getHarvestTool(Lnet/minecraft/block/state/IBlockState;)Ljava/lang/String;")})
    private static void getHarvestToolForArchitectureCraft(IProbeInfo probeInfo, World world, BlockPos pos, Block block, IBlockState blockState, EntityPlayer player, CallbackInfo ci, @Local LocalRef<String> harvestTool) {
        float blockHardness;
        if (!Loader.isModLoaded((String)"architecturecraft") || !LabsConfig.modIntegration.enableArchitectureCraftIntegration || HarvestInfoToolsMixin.isNotShapeForArchitectureCraft(block)) {
            return;
        }
        IBlockState baseBlockState = HarvestInfoToolsMixin.getBaseBlockStateForArchitectureCraft(world, pos);
        if (baseBlockState == null) {
            return;
        }
        String retrievedHarvestTool = baseBlockState.func_177230_c().getHarvestTool(baseBlockState);
        if (retrievedHarvestTool == null && (blockHardness = baseBlockState.func_185887_b(world, pos)) > 0.0f) {
            for (Map.Entry<String, ItemStack> testToolEntry : testTools.entrySet()) {
                Item item;
                ItemStack testTool = testToolEntry.getValue();
                if (testTool == null || !((item = testTool.func_77973_b()) instanceof ItemTool)) continue;
                ItemTool toolItem = (ItemTool)item;
                if (!(testTool.func_150997_a(baseBlockState) >= toolItem.field_77862_b.func_77998_b())) continue;
                retrievedHarvestTool = testToolEntry.getKey();
                break;
            }
        }
        harvestTool.set((Object)retrievedHarvestTool);
    }

    @Inject(method={"showHarvestInfo"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/block/Block;getHarvestLevel(Lnet/minecraft/block/state/IBlockState;)I")})
    private static void getHarvestLevelForArchitectureCraft(IProbeInfo probeInfo, World world, BlockPos pos, Block block, IBlockState blockState, EntityPlayer player, CallbackInfo ci, @Local LocalIntRef harvestLevel) {
        if (!Loader.isModLoaded((String)"architecturecraft") || !LabsConfig.modIntegration.enableArchitectureCraftIntegration || HarvestInfoToolsMixin.isNotShapeForArchitectureCraft(block)) {
            return;
        }
        IBlockState baseBlockState = HarvestInfoToolsMixin.getBaseBlockStateForArchitectureCraft(world, pos);
        if (baseBlockState == null) {
            return;
        }
        harvestLevel.set(baseBlockState.func_177230_c().getHarvestLevel(baseBlockState));
    }

    @Unique
    private static boolean isNotShapeForArchitectureCraft(Block block) {
        try {
            Class<?> shapeClass = Class.forName("com.elytradev.architecture.common.block.BlockShape");
            return !shapeClass.isInstance(block);
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    @Unique
    @Nullable
    private static IBlockState getBaseBlockStateForArchitectureCraft(World world, BlockPos pos) {
        try {
            Class<?> tileShapeClass = Class.forName("com.elytradev.architecture.common.tile.TileShape");
            Method getTileMethod = tileShapeClass.getDeclaredMethod("get", IBlockAccess.class, BlockPos.class);
            Object tile = getTileMethod.invoke(null, world, pos);
            if (tile == null) {
                return null;
            }
            Method getBaseBlockStateMethod = tile.getClass().getDeclaredMethod("getBaseBlockState", new Class[0]);
            return (IBlockState)getBaseBlockStateMethod.invoke(tile, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }
}

