/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.topaddons;

import com.nomiceu.nomilabs.integration.top.LabsFluidNameElement;
import com.nomiceu.nomilabs.integration.top.LabsFluidStackElement;
import com.nomiceu.nomilabs.util.LabsTranslate;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.utils.RenderUtil;
import io.github.drmanganese.topaddons.elements.ElementRenderHelper;
import io.github.drmanganese.topaddons.elements.ElementTankGauge;
import java.util.Objects;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ElementTankGauge.class}, remap=false)
public class ElementTankGaugeMixin {
    @Shadow
    @Final
    @Mutable
    private String fluidName;
    @Shadow
    @Final
    private int amount;
    @Shadow
    @Final
    private int capacity;
    @Shadow
    @Final
    private String tankName;
    @Shadow
    @Final
    private String suffix;
    @Shadow
    @Mutable
    @Final
    private int color1;
    @Shadow
    @Final
    private boolean sneaking;
    @Shadow
    @Final
    private int color2;
    @Unique
    private String labs$tankFluidTitle = null;
    @Unique
    private String labs$capacityInfo = null;
    @Unique
    private TextureAtlasSprite labs$sprite = null;

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void newRenderLogic(int x, int y, CallbackInfo ci) {
        boolean hasFluid = this.labs$hasFluid();
        boolean expand = this.labs$shouldExpand();
        int barHeight = expand ? 12 : 8;
        ci.cancel();
        if (hasFluid && this.labs$sprite == null) {
            this.labs$sprite = LabsFluidStackElement.getFluidAtlasSprite("ElementTankGuage", this.fluidName);
        }
        int borderColor = hasFluid ? this.color2 : -6908266;
        RenderHelper.drawThickBeveledBox((int)x, (int)y, (int)(x + 100), (int)(y + barHeight), (int)1, (int)borderColor, (int)borderColor, (int)0x44969696);
        if (hasFluid && this.labs$sprite != null) {
            this.labs$renderFluidTexture(x, y, barHeight);
        }
        for (int i = 1; i < 10; ++i) {
            RenderHelper.drawVerticalLine((int)(x + i * 10), (int)(y + 1), (int)(y + (i == 5 ? barHeight - 1 : barHeight / 2)), (int)borderColor);
        }
        if (expand) {
            ElementTextRender.render((String)this.labs$getCapacityInfo(), (int)(x + 3), (int)(y + 2));
            ElementTextRender.render((String)this.labs$getTankFluidTitle(), (int)(x + 1), (int)(y + 14));
        } else {
            ElementRenderHelper.drawSmallText((int)(x + 2), (int)(y + 2), (String)this.labs$getTranslatedTankName(), (int)-1);
        }
    }

    @Inject(method={"getWidth"}, at={@At(value="HEAD")}, cancellable=true)
    private void newWidthLogic(CallbackInfoReturnable<Integer> cir) {
        if (this.labs$shouldExpand()) {
            cir.setReturnValue((Object)Math.max(100, Minecraft.func_71410_x().field_71466_p.func_78256_a(this.labs$getTankFluidTitle())));
        }
    }

    @Inject(method={"getHeight"}, at={@At(value="HEAD")}, cancellable=true)
    private void newHeightLogic(CallbackInfoReturnable<Integer> cir) {
        if (this.labs$shouldExpand()) {
            cir.setReturnValue((Object)25);
        } else {
            cir.setReturnValue((Object)8);
        }
    }

    @Unique
    private boolean labs$shouldExpand() {
        return this.sneaking && this.labs$hasFluid();
    }

    @Unique
    private boolean labs$hasFluid() {
        return this.capacity > 0 && this.fluidName != null && !this.fluidName.isEmpty();
    }

    @Unique
    private void labs$renderFluidTexture(int x, int y, int barHeight) {
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderUtil.setGlColorFromInt((int)this.color1, (int)255);
        int scaledAmount = (int)((long)this.amount * 98L / (long)this.capacity);
        int xTileCount = scaledAmount / 16;
        int xRemainder = scaledAmount - xTileCount * 16;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int width = xTile == xTileCount ? xRemainder : 16;
            int fluidX = x + 1 + (xTile + 1) * 16 - 16;
            if (width <= 0) continue;
            int maskTop = 16 - barHeight + 2;
            int maskRight = 16 - width;
            RenderUtil.drawFluidTexture((double)fluidX, (double)(y - 16 + barHeight - 1), (TextureAtlasSprite)this.labs$sprite, (int)maskTop, (int)maskRight, (double)0.0);
        }
        GlStateManager.func_179084_k();
    }

    @Unique
    private String labs$getTankFluidTitle() {
        if (this.labs$tankFluidTitle != null) {
            return this.labs$tankFluidTitle;
        }
        this.labs$tankFluidTitle = this.labs$getTranslatedTankName() + ": " + LabsFluidNameElement.translateFluid(this.fluidName, this.amount, "ElementTankGauge");
        return this.labs$tankFluidTitle;
    }

    @Unique
    private String labs$getTranslatedTankName() {
        return LabsTranslate.translate(this.tankName, new Object[0]);
    }

    @Unique
    private String labs$getCapacityInfo() {
        if (this.labs$capacityInfo != null) {
            return this.labs$capacityInfo;
        }
        String suffixToUse = this.suffix;
        if (Objects.equals(this.suffix, "mB")) {
            suffixToUse = "L";
        }
        this.labs$capacityInfo = TextFormattingUtil.formatLongToCompactString((long)this.amount) + suffixToUse + " / " + TextFormattingUtil.formatLongToCompactString((long)this.capacity) + suffixToUse;
        return this.labs$capacityInfo;
    }
}

