/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.vanilla;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.config.LabsVersionConfig;
import com.nomiceu.nomilabs.mixinhelper.DifficultySettableServer;
import com.nomiceu.nomilabs.util.LabsDifficultyHelper;
import com.nomiceu.nomilabs.util.LabsModeHelper;
import com.nomiceu.nomilabs.util.LabsTranslate;
import java.io.File;
import java.net.Proxy;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.EnumDifficulty;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DedicatedServer.class})
public abstract class DedicatedServerMixin
extends MinecraftServer
implements DifficultySettableServer {
    @Shadow
    private PropertyManager field_71340_o;

    public DedicatedServerMixin(File anvilFileIn, Proxy proxyIn, DataFixer dataFixerIn, YggdrasilAuthenticationService authServiceIn, MinecraftSessionService sessionServiceIn, GameProfileRepository profileRepoIn, PlayerProfileCache profileCacheIn) {
        super(anvilFileIn, proxyIn, dataFixerIn, authServiceIn, sessionServiceIn, profileRepoIn, profileCacheIn);
    }

    @Inject(method={"getDifficulty"}, at={@At(value="HEAD")}, cancellable=true)
    public void getLockedDifficulty(CallbackInfoReturnable<EnumDifficulty> cir) {
        EnumDifficulty locked = LabsDifficultyHelper.getLockedDifficulty();
        if (locked != null) {
            cir.setReturnValue((Object)locked);
        }
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/dedicated/DedicatedServer;setMOTD(Ljava/lang/String;)V"))
    public void motdSubstitutions(DedicatedServer instance, String s) {
        if (!LabsConfig.advanced.serverMotdSubstitutions) {
            return;
        }
        NomiLabs.LOGGER.info("Enabling Labs MOTD Substitutions...");
        instance.func_71205_p(s.replace("{version}", LabsVersionConfig.formattedVersion).replace("{mode}", LabsModeHelper.getFormattedMode()));
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    public void changeInitDifficulty(CallbackInfoReturnable<EnumDifficulty> cir) {
        EnumDifficulty locked = LabsDifficultyHelper.getLockedDifficulty();
        int savedDifficulty = this.field_71340_o.func_73669_a("difficulty", 1);
        if (locked != null && savedDifficulty != locked.func_151525_a()) {
            NomiLabs.LOGGER.warn("===============================================");
            NomiLabs.LOGGER.warn("============ LABS DIFFICULTY LOCK: ============");
            NomiLabs.LOGGER.warn("-----------------------------------------------");
            NomiLabs.LOGGER.warn("Server Difficulty was set to {}, it has now been overrided to {}!", (Object)LabsTranslate.translate(EnumDifficulty.func_151523_a((int)savedDifficulty).func_151526_b(), new Object[0]), (Object)LabsTranslate.translate(locked.func_151526_b(), new Object[0]));
            NomiLabs.LOGGER.warn("This is because you are on {} mode!", (Object)LabsModeHelper.getFormattedMode());
            NomiLabs.LOGGER.warn("-----------------------------------------------");
            NomiLabs.LOGGER.warn("===============================================");
            this.field_71340_o.func_73667_a("difficulty", (Object)locked.func_151525_a());
            this.field_71340_o.func_73668_b();
        }
    }

    @Override
    public void setDifficultyForAllWorldsAndSave(EnumDifficulty difficulty) {
        this.func_147139_a(difficulty);
        this.field_71340_o.func_73667_a("difficulty", (Object)difficulty.func_151525_a());
        this.field_71340_o.func_73668_b();
    }
}

