/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.vanilla;

import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.mixinhelper.AccessibleModListMessage;
import com.nomiceu.nomilabs.util.LabsModeHelper;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FMLNetworkHandler.class}, remap=false)
public class FMLNetworkHandlerMixin {
    @Inject(method={"checkModList(Lnet/minecraftforge/fml/common/network/handshake/FMLHandshakeMessage$ModList;Lnet/minecraftforge/fml/relauncher/Side;)Ljava/lang/String;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void checkModeInfo(FMLHandshakeMessage.ModList modListPacket, Side side, CallbackInfoReturnable<String> cir) {
        if (cir.getReturnValue() != null) {
            NomiLabs.LOGGER.error("[Labs Mode Validation] Ignoring Mode Checks due to Invalid Mod List!");
            return;
        }
        String mode = ((AccessibleModListMessage)modListPacket).labs$getMode();
        if (mode.isEmpty()) {
            NomiLabs.LOGGER.error("[Labs Mode Validation] No Mode Data!");
            cir.setReturnValue((Object)"\u00a7cMode Validation Failed!\u00a7r\n\nCheck your client and server, and make sure they are on the same version!");
            return;
        }
        if (mode.equals(LabsModeHelper.getMode())) {
            NomiLabs.LOGGER.info("[Labs Mode Validation] Mode Match.");
            return;
        }
        NomiLabs.LOGGER.error("[Labs Mode Validation] Mode Mismatch! Received: {}, Expected: {}", (Object)mode, (Object)LabsModeHelper.getMode());
        String modeMismatchText = side.isServer() ? String.format("Server expects mode \u00a7a%s\u00a7r, but you are on mode \u00a7e%s\u00a7r!", LabsModeHelper.formatMode(mode), LabsModeHelper.getFormattedMode()) : String.format("Server expects mode \u00a7a%s\u00a7r, but you are on mode \u00a7e%s\u00a7r!", LabsModeHelper.getFormattedMode(), LabsModeHelper.formatMode(mode));
        String linkText = "";
        if (LabsConfig.advanced.modeCheckNomiCeuLink) {
            linkText = "\n\nSee \u00a7bhttps://github.com/Nomi-CEu/Nomi-CEu/blob/main/overrides/README.md\u00a7r for information on switching modes!";
        }
        cir.setReturnValue((Object)("\u00a7cServer Mode Rejection:\u00a7r\n\n" + modeMismatchText + linkText));
    }
}

