/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.vanilla;

import com.google.common.collect.BiMap;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.fluid.FluidRegistryMixinHelper;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FluidRegistry.class}, remap=false)
public class FluidRegistryMixin {
    @Shadow
    static BiMap<String, Fluid> fluids;
    @Shadow
    static BiMap<Fluid, Integer> fluidIDs;
    @Shadow
    static BiMap<Integer, String> fluidNames;
    @Shadow
    static BiMap<String, String> defaultFluidName;
    @Shadow
    static BiMap<String, Fluid> masterFluidReference;

    @Inject(method={"loadFluidDefaults(Lcom/google/common/collect/BiMap;Ljava/util/Set;)V"}, at={@At(value="FIELD", target="Lnet/minecraftforge/fluids/FluidRegistry;currentBucketFluids:Ljava/util/Set;", shift=At.Shift.AFTER)}, require=1)
    private static void loadSpecifiedFluidDefaults(BiMap<Fluid, Integer> localFluidIDs, Set<String> defaultNames, CallbackInfo ci) {
        Map<String, String> defaultFluids = FluidRegistryMixinHelper.getDefaultFluids();
        if (defaultFluids == null) {
            return;
        }
        int changed = 0;
        for (Map.Entry<String, String> entry : defaultFluids.entrySet()) {
            NomiLabs.LOGGER.debug("Processing Conflict {}", (Object)entry.getKey());
            Fluid fluid = (Fluid)masterFluidReference.get((Object)entry.getValue());
            Fluid oldFluid = (Fluid)fluids.get((Object)entry.getKey());
            String oldName = (String)masterFluidReference.inverse().get((Object)oldFluid);
            if (oldName.equals(entry.getValue())) {
                NomiLabs.LOGGER.debug("Default fluid of {} is already {}. Not Changing...", (Object)entry.getKey(), (Object)entry.getValue());
                continue;
            }
            NomiLabs.LOGGER.debug("Changing default fluid of {}, from {} to {}.", (Object)entry.getKey(), (Object)oldName, (Object)entry.getValue());
            ++changed;
            fluids.forcePut((Object)entry.getKey(), (Object)fluid);
            defaultFluidName.forcePut((Object)entry.getKey(), (Object)entry.getValue());
            Integer id = (Integer)localFluidIDs.remove((Object)oldFluid);
            localFluidIDs.forcePut((Object)fluid, (Object)id);
            fluidNames.forcePut((Object)id, (Object)entry.getKey());
        }
        if (changed == 0) {
            NomiLabs.LOGGER.info("No Fluids Changed.");
            return;
        }
        NomiLabs.LOGGER.info("Changed {} Default Fluid(s)!", (Object)changed);
        fluidIDs = localFluidIDs;
    }
}

