/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.vanilla;

import com.google.common.collect.Maps;
import com.llamalad7.mixinextras.sugar.Local;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.mixinhelper.RemappableForgeRegistry;
import com.nomiceu.nomilabs.mixinhelper.RemappableSnapshot;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ForgeRegistry.class}, remap=false)
public abstract class ForgeRegistryMixin<V extends IForgeRegistryEntry<V>>
implements IForgeRegistryInternal<V>,
IForgeRegistryModifiable<V>,
RemappableForgeRegistry {
    @Shadow
    @Final
    private Set<Integer> blocked;
    @Unique
    private final Map<Integer, ResourceLocation> remapped = Maps.newHashMap();

    @Shadow
    abstract void block(int var1);

    @Inject(method={"processMissingEvent"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/registries/ForgeRegistry;addAlias(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/util/ResourceLocation;)V")}, require=1, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    public void handleRemaps(ResourceLocation name, ForgeRegistry<V> pool, List<RegistryEvent.MissingMappings.Mapping<V>> mappings, Map<ResourceLocation, Integer> missing, Map<ResourceLocation, Integer[]> remaps, Collection<ResourceLocation> defaulted, Collection<ResourceLocation> failed, boolean injectNetworkDummies, CallbackInfo ci, @Local RegistryEvent.MissingMappings.Mapping<V> remap, @Local(ordinal=2) int realId) {
        if (remap.id != realId) {
            this.block(remap.id);
            this.remapped.put(remap.id, remap.getTarget().getRegistryName());
            NomiLabs.LOGGER.warn("[Forge Registry] Remap could not assign Id {} for Object {}! If this is of type BLOCK, without Data Fixers, after initial load, blocks will no longer be remapped!", (Object)remap.id, (Object)remap.getTarget().getRegistryName());
        }
    }

    @Inject(method={"sync"}, at={@At(value="RETURN")})
    void syncBlockedRemapped(ResourceLocation name, ForgeRegistry<V> from, CallbackInfo ci) {
        this.blocked.clear();
        RemappableForgeRegistry remFrom = (RemappableForgeRegistry)from;
        remFrom.getBlocked().forEach(this::block);
        this.remapped.clear();
        remFrom.getRemapped().forEach(this::addRemapped);
    }

    @Inject(method={"makeSnapshot"}, at={@At(value="RETURN")})
    public void addRemappedToSnapshot(CallbackInfoReturnable<ForgeRegistry.Snapshot> cir) {
        ForgeRegistry.Snapshot ret = (ForgeRegistry.Snapshot)cir.getReturnValue();
        ((RemappableSnapshot)ret).addAllRemapped(this.remapped);
    }

    @Override
    @Unique
    public void addRemapped(int id, ResourceLocation key) {
        this.remapped.put(id, key);
    }

    @Override
    @Unique
    public Map<Integer, ResourceLocation> getRemapped() {
        return this.remapped;
    }

    @Override
    @Unique
    public Set<Integer> getBlocked() {
        return this.blocked;
    }
}

