/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.vanilla;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.cleanroommc.groovyscript.compat.vanilla.VanillaModule;
import com.cleanroommc.groovyscript.helper.ingredient.OreDictIngredient;
import com.nomiceu.nomilabs.config.LabsConfig;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"getRepairCost()I"}, at={@At(value="HEAD")}, cancellable=true)
    public void getRepairCost(CallbackInfoReturnable<Integer> cir) {
        if (LabsConfig.advanced.disableXpScaling) {
            cir.setReturnValue((Object)0);
        }
    }

    @Unique
    public List<OreDictIngredient> getAllOreDicts() {
        return this.getOreDictNames().stream().map(OreDictIngredient::new).collect(Collectors.toList());
    }

    @Unique
    @GroovyBlacklist
    private List<String> getOreDictNames() {
        ItemStack stack = (ItemStack)this;
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        return Arrays.stream(ids).mapToObj(OreDictionary::getOreName).collect(Collectors.toList());
    }

    @Unique
    public void removeAllOreDicts() {
        ItemStack stack = (ItemStack)this;
        this.getOreDictNames().forEach(name -> VanillaModule.oreDict.remove(name, stack));
    }
}

