/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.vanilla;

import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.event.LabsResourcesRefreshedEvent;
import com.nomiceu.nomilabs.mixinhelper.ResourcesObserver;
import com.nomiceu.nomilabs.util.LabsDisplayHelper;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Util;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.Display;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Inject(method={"refreshResources"}, at={@At(value="RETURN")})
    private void callResourcesRefreshedEvent(CallbackInfo ci) {
        if (ResourcesObserver.shouldCallEvent()) {
            MinecraftForge.EVENT_BUS.post((Event)new LabsResourcesRefreshedEvent());
        }
    }

    @Redirect(method={"createDisplay"}, at=@At(value="INVOKE", target="Lorg/lwjgl/opengl/Display;setTitle(Ljava/lang/String;)V", remap=false), require=1)
    private void setCustomTitle(String title) {
        if (LabsConfig.advanced.windowOverrides.windowTitleOverride.isEmpty()) {
            Display.setTitle((String)title);
        } else {
            Display.setTitle((String)LabsDisplayHelper.getWindowTitle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Inject(method={"setWindowIcon"}, at={@At(value="HEAD")}, cancellable=true)
    public void setCustomWindowIcon(CallbackInfo ci) {
        block9: {
            x16 = LabsDisplayHelper.formatImagePath(LabsConfig.advanced.windowOverrides.windowLogo16xOverride);
            x32 = LabsDisplayHelper.formatImagePath(LabsConfig.advanced.windowOverrides.windowLogo32xOverride);
            x256 = LabsDisplayHelper.formatImagePath(LabsConfig.advanced.windowOverrides.windowLogo256xOverride);
            if (x16.isEmpty() || x32.isEmpty() || x256.isEmpty()) {
                return;
            }
            NomiLabs.LOGGER.info("Replacing Window Icons: 16x: {}, 32x: {}, 256x: {}.", (Object)x16, (Object)x32, (Object)x256);
            stream16 = null;
            stream32 = null;
            stream256 = null;
            osX = Util.func_110647_a() == Util.EnumOS.OSX;
            try {
                stream16 = new FileInputStream(x16);
                stream32 = new FileInputStream(x32);
                if (osX) {
                    stream256 = new FileInputStream(x256);
                    Display.setIcon((ByteBuffer[])new ByteBuffer[]{MinecraftMixin.labs$readImageToBuffer(stream16, 16), MinecraftMixin.labs$readImageToBuffer(stream32, 32), MinecraftMixin.labs$readImageToBuffer(stream256, 256)});
                    break block9;
                }
                Display.setIcon((ByteBuffer[])new ByteBuffer[]{MinecraftMixin.labs$readImageToBuffer(stream16, 16), MinecraftMixin.labs$readImageToBuffer(stream32, 32)});
            }
            catch (IOException ex) {
                try {
                    NomiLabs.LOGGER.error("Failed to Read Custom Window Icon! Is the Path Correct?", (Throwable)ex);
                }
                catch (Throwable var10_10) {
                    IOUtils.closeQuietly(stream16);
                    IOUtils.closeQuietly(stream32);
                    if (osX) {
                        IOUtils.closeQuietly(stream256);
                    }
                    throw var10_10;
                }
                IOUtils.closeQuietly((InputStream)stream16);
                IOUtils.closeQuietly((InputStream)stream32);
                if (osX) {
                    IOUtils.closeQuietly(stream256);
                } else {
                    ** GOTO lbl41
                }
            }
        }
        IOUtils.closeQuietly((InputStream)stream16);
        IOUtils.closeQuietly((InputStream)stream32);
        if (osX) {
            IOUtils.closeQuietly((InputStream)stream256);
        }
        ci.cancel();
    }

    @Unique
    private static ByteBuffer labs$readImageToBuffer(InputStream stream, int dimensions) throws IOException {
        BufferedImage image = ImageIO.read(stream);
        if (image.getWidth() != dimensions || image.getHeight() != dimensions) {
            GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = environment.getDefaultScreenDevice();
            GraphicsConfiguration gc = device.getDefaultConfiguration();
            BufferedImage resized = gc.createCompatibleImage(dimensions, dimensions, image.getTransparency());
            Graphics2D graphics = resized.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawImage(image, 0, 0, dimensions, dimensions, null);
            graphics.dispose();
            image = resized;
        }
        int[] rgb = image.getRGB(0, 0, dimensions, dimensions, null, 0, dimensions);
        ByteBuffer buffer = ByteBuffer.allocate(rgb.length * 4);
        for (int i : rgb) {
            buffer.putInt(i << 8 | i >> 24 & 0xFF);
        }
        buffer.flip();
        return buffer;
    }
}

