/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.vanilla;

import com.google.common.collect.Maps;
import com.nomiceu.nomilabs.mixinhelper.RemappableForgeRegistry;
import com.nomiceu.nomilabs.mixinhelper.RemappableSnapshot;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ForgeRegistry.Snapshot.class}, remap=false)
public class SnapshotMixin
implements RemappableSnapshot {
    @Unique
    public Map<Integer, ResourceLocation> remapped = Maps.newHashMap();
    @Unique
    private static final String REMAPPED_KEY = "remapped";

    @Inject(method={"write"}, at={@At(value="RETURN")})
    public void saveRemapped(CallbackInfoReturnable<NBTTagCompound> cir) {
        NBTTagCompound data = (NBTTagCompound)cir.getReturnValue();
        NBTTagList remapList = new NBTTagList();
        this.remapped.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("K", ((Integer)e.getKey()).intValue());
            tag.func_74778_a("V", ((ResourceLocation)e.getValue()).toString());
            remapList.func_74742_a((NBTBase)tag);
        });
        data.func_74782_a(REMAPPED_KEY, (NBTBase)remapList);
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void readRemapped(NBTTagCompound nbt, CallbackInfoReturnable<ForgeRegistry.Snapshot> cir) {
        ForgeRegistry.Snapshot ret = (ForgeRegistry.Snapshot)cir.getReturnValue();
        NBTTagList list = nbt.func_150295_c(REMAPPED_KEY, 10);
        list.forEach(e -> {
            NBTTagCompound comp = (NBTTagCompound)e;
            ((RemappableSnapshot)ret).addRemapped(comp.func_74762_e("K"), new ResourceLocation(comp.func_74779_i("V")));
        });
    }

    @Override
    @Unique
    public void addRemapped(int id, ResourceLocation key) {
        this.remapped.put(id, key);
    }

    @Override
    @Unique
    public void addAllRemapped(Map<Integer, ResourceLocation> map) {
        this.remapped.putAll(map);
    }

    @Override
    @Unique
    public void loadToRegistry(RemappableForgeRegistry reg) {
        this.remapped.forEach(reg::addRemapped);
    }
}

