/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixinhelper;

import com.nomiceu.nomilabs.NomiLabs;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public class GuiCustomConfirmOpenLink
extends GuiScreen {
    private final GuiScreen parent;
    private final String titleText;
    private final String confirmButtonText;
    private final String cancelButtonText;
    private final String copyLinkButtonText;
    private final String linkText;
    private final boolean hasNoteText;
    private final String noteText;
    private final List<String> listLines;
    private static final int CONFIRM_ID = 0;
    private static final int COPY_ID = 2;
    private static final int CANCEL_ID = 1;

    public GuiCustomConfirmOpenLink(GuiScreen parent, String linkText, @Nullable String noteText) {
        this.parent = parent;
        this.titleText = TextFormatting.BOLD + I18n.func_135052_a((String)"chat.link.confirmTrusted", (Object[])new Object[0]);
        this.confirmButtonText = I18n.func_135052_a((String)"chat.link.open", (Object[])new Object[0]);
        this.cancelButtonText = I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]);
        this.copyLinkButtonText = I18n.func_135052_a((String)"chat.copy", (Object[])new Object[0]);
        this.noteText = noteText;
        this.hasNoteText = this.noteText != null;
        this.linkText = linkText;
        this.listLines = new ArrayList<String>();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.makeButton(0, -105, this.confirmButtonText);
        this.makeButton(2, 0, this.copyLinkButtonText);
        this.makeButton(1, 105, this.cancelButtonText);
        this.listLines.clear();
        this.listLines.addAll(this.field_146289_q.func_78271_c(TextFormatting.AQUA + this.linkText + TextFormatting.RESET, this.field_146294_l - 50));
    }

    private void makeButton(int id, int xOffset, String displayText) {
        this.field_146292_n.add(new GuiButton(id, this.field_146294_l / 2 - 50 + xOffset, this.field_146295_m / 6 + 96, 100, 20, displayText));
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 2) {
            GuiCustomConfirmOpenLink.func_146275_d((String)this.linkText);
        }
        if (button.field_146127_k == 0) {
            GuiCustomConfirmOpenLink.openLink(this.linkText);
        }
        this.field_146297_k.func_147108_a(this.parent);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.titleText, this.field_146294_l / 2, 70 - (this.hasNoteText ? 20 : 0), 0xFFFFFF);
        if (this.hasNoteText) {
            this.func_73732_a(this.field_146289_q, this.noteText, this.field_146294_l / 2, 70, 0xFFFFFF);
        }
        int i = 90;
        for (String s : this.listLines) {
            this.func_73732_a(this.field_146289_q, s, this.field_146294_l / 2, i, 0xFFFFFF);
            i += this.field_146289_q.field_78288_b;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public static void openLink(String url) {
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object desktopObj = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopClass.getMethod("browse", URI.class).invoke(desktopObj, new URI(url));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException | URISyntaxException e) {
            NomiLabs.LOGGER.error("Failed to Open Link!");
            NomiLabs.LOGGER.throwing((Throwable)e);
        }
    }
}

