/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.network;

import com.nomiceu.nomilabs.integration.betterp2p.AccessibleGridServerCache;
import com.projecturanus.betterp2p.network.ModNetwork;
import com.projecturanus.betterp2p.network.PlayerRequest;
import com.projecturanus.betterp2p.network.data.P2PLocation;
import com.projecturanus.betterp2p.network.data.P2PLocationKt;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class LabsP2PAddAsOutputMessage
implements IMessage {
    private P2PLocation location;
    private short sourceFrequency;

    public LabsP2PAddAsOutputMessage() {
        this.location = null;
        this.sourceFrequency = 0;
    }

    public LabsP2PAddAsOutputMessage(P2PLocation location, short sourceFrequency) {
        this.location = location;
        this.sourceFrequency = sourceFrequency;
    }

    public void fromBytes(ByteBuf buf) {
        this.location = P2PLocationKt.readP2PLocation((ByteBuf)buf);
        this.sourceFrequency = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        P2PLocationKt.writeP2PLocation((ByteBuf)buf, (P2PLocation)this.location);
        buf.writeShort((int)this.sourceFrequency);
    }

    public static class MessageHandler
    implements IMessageHandler<LabsP2PAddAsOutputMessage, IMessage> {
        public IMessage onMessage(LabsP2PAddAsOutputMessage message, MessageContext ctx) {
            if (!ctx.side.isServer()) {
                return null;
            }
            PlayerRequest state = (PlayerRequest)ModNetwork.INSTANCE.getPlayerState().get(ctx.getServerHandler().field_147369_b.func_110124_au());
            if (state == null) {
                return null;
            }
            ctx.getServerHandler().field_147367_d.func_152344_a(() -> {
                boolean result = ((AccessibleGridServerCache)state.getGridCache()).labs$addOutput(message.location, message.sourceFrequency);
                if (result) {
                    ModNetwork.INSTANCE.requestP2PUpdate((EntityPlayer)ctx.getServerHandler().field_147369_b);
                }
            });
            return null;
        }
    }
}

