/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.network;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IParts;
import co.neeve.nae2.NAE2;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.authlib.GameProfile;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.util.ItemMeta;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class LabsP2PCycleMessage
implements IMessage {
    private int hand;
    private byte offset;
    private int expectedSlot;

    public LabsP2PCycleMessage() {
        this.hand = EnumHand.MAIN_HAND.ordinal();
        this.offset = 0;
        this.expectedSlot = 0;
    }

    public LabsP2PCycleMessage(EntityPlayer player, EnumHand hand, byte offset) {
        this.hand = hand.ordinal();
        this.offset = offset;
        this.expectedSlot = hand == EnumHand.MAIN_HAND ? player.field_71071_by.field_70461_c : 0;
    }

    public int getOffset() {
        return this.offset;
    }

    public EnumHand getHand() {
        return EnumHand.values()[this.hand];
    }

    public boolean checkValid(EntityPlayer player) {
        return this.getHand() == EnumHand.OFF_HAND || player.field_71071_by.field_70461_c == this.expectedSlot;
    }

    public void fromBytes(ByteBuf buf) {
        this.hand = buf.readInt();
        this.offset = buf.readByte();
        this.expectedSlot = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.hand);
        buf.writeByte((int)this.offset);
        buf.writeInt(this.expectedSlot);
    }

    public static class MessageHandler
    implements IMessageHandler<LabsP2PCycleMessage, IMessage> {
        private static BiMap<ItemMeta, Integer> p2ps = null;

        public static BiMap<ItemMeta, Integer> getP2ps() {
            if (p2ps != null) {
                return p2ps;
            }
            p2ps = HashBiMap.create();
            IParts parts = AEApi.instance().definitions().parts();
            MessageHandler.addP2pFromDef(parts.p2PTunnelME());
            MessageHandler.addP2pFromDef(parts.p2PTunnelRedstone());
            MessageHandler.addP2pFromDef(parts.p2PTunnelItems());
            MessageHandler.addP2pFromDef(parts.p2PTunnelFluids());
            MessageHandler.addP2pFromDef(parts.p2PTunnelLight());
            MessageHandler.addP2pFromDef(parts.p2PTunnelFE());
            MessageHandler.addP2pFromDef(parts.p2PTunnelEU());
            MessageHandler.addP2pFromDef(parts.p2PTunnelGTEU());
            if (Loader.isModLoaded((String)"nae2")) {
                MessageHandler.addNae2P2ps();
            }
            return p2ps;
        }

        @Optional.Method(modid="nae2")
        private static void addNae2P2ps() {
            MessageHandler.addP2pFromDef((IItemDefinition)NAE2.definitions().parts().p2pTunnelInterface());
        }

        private static void addP2pFromDef(IItemDefinition def) {
            def.maybeStack(1).ifPresent(itemStack -> p2ps.put((Object)new ItemMeta((ItemStack)itemStack), (Object)p2ps.size()));
        }

        private static void tryCycle(EntityPlayer player, LabsP2PCycleMessage cycle) {
            if (cycle.checkValid(player)) {
                ItemStack heldStack = player.func_184586_b(cycle.getHand());
                ItemMeta held = new ItemMeta(heldStack);
                if (!MessageHandler.getP2ps().containsKey((Object)held)) {
                    GameProfile profile = player.func_146103_bH();
                    String item = Objects.toString(held.getItem().getRegistryName(), "an unregistered item");
                    NomiLabs.LOGGER.warn("{} ({}) tried to cycle {}", (Object)profile.getName(), (Object)profile.getId(), (Object)item);
                    return;
                }
                int newValue = ((Integer)MessageHandler.getP2ps().get((Object)held) + cycle.getOffset()) % p2ps.size();
                if (newValue < 0) {
                    newValue += p2ps.size();
                }
                ItemStack next = ((ItemMeta)MessageHandler.getP2ps().inverse().get((Object)newValue)).toStack();
                next.func_190920_e(heldStack.func_190916_E());
                next.func_77982_d(heldStack.func_77978_p());
                player.func_184611_a(cycle.getHand(), next);
            }
        }

        public IMessage onMessage(LabsP2PCycleMessage message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> MessageHandler.tryCycle((EntityPlayer)ctx.getServerHandler().field_147369_b, message));
            return null;
        }
    }
}

