/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.recipe;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IFrameable;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityFramingTable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class HandFramingRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe,
IShapedRecipe {
    public HandFramingRecipe(ResourceLocation rl) {
        this.setRegistryName(rl);
    }

    public boolean func_77569_a(InventoryCrafting inv, @NotNull World worldIn) {
        if (inv.func_174922_i() == 2 && inv.func_174923_h() == 2) {
            return this.check2x2Grid(inv, 0, 0);
        }
        if (inv.func_174922_i() == 3 && inv.func_174923_h() == 3) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (!this.check2x2Grid(inv, i, j) || !this.checkRemainingEmpty(inv, i, j)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean check2x2Grid(InventoryCrafting inv, int offsetX, int offsetY) {
        ItemStack topLeft = inv.func_70463_b(offsetX, offsetY);
        ItemStack bottomRight = inv.func_70463_b(offsetX + 1, offsetY + 1);
        return this.isValidCraftingSet(topLeft, bottomRight);
    }

    private boolean checkRemainingEmpty(InventoryCrafting inv, int offsetX, int offsetY) {
        for (int i = 0; i < inv.func_174922_i(); ++i) {
            for (int j = 0; j < inv.func_174923_h(); ++j) {
                if (i >= offsetX && i < offsetX + 2 && j >= offsetY && j < offsetY + 2 || inv.func_70463_b(i, j).func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public ItemStack func_77572_b(@NotNull InventoryCrafting inv) {
        for (int i = 0; i <= 1; ++i) {
            for (int j = 0; j <= 1; ++j) {
                ItemStack resultStack = this.tryCraftingAt(inv, i, j);
                if (resultStack.func_190926_b()) continue;
                return resultStack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    private ItemStack tryCraftingAt(InventoryCrafting inv, int i, int j) {
        ItemStack topLeft = inv.func_70463_b(i, j).func_77946_l();
        ItemStack topRight = inv.func_70463_b(i + 1, j).func_77946_l();
        ItemStack bottomLeft = inv.func_70463_b(i, j + 1).func_77946_l();
        ItemStack bottomRight = inv.func_70463_b(i + 1, j + 1).func_77946_l();
        if (this.isValidCraftingSet(topLeft, bottomRight)) {
            return ((IFrameable)bottomRight.func_77973_b()).decorate(bottomRight, topLeft, this.getValidStackOrEmpty(topRight), this.getValidStackOrEmpty(bottomLeft));
        }
        return ItemStack.field_190927_a;
    }

    private boolean isValidCraftingSet(ItemStack side, ItemStack frameable) {
        return TileEntityFramingTable.isItemValidDrawer((ItemStack)frameable) && TileEntityFramingTable.isItemValidMaterial((ItemStack)side);
    }

    private ItemStack getValidStackOrEmpty(ItemStack stack) {
        if (TileEntityFramingTable.isItemValidMaterial((ItemStack)stack)) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @NotNull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    public int getRecipeWidth() {
        return 2;
    }

    public int getRecipeHeight() {
        return 2;
    }
}

