/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.remap;

import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.config.LabsVersionConfig;
import com.nomiceu.nomilabs.remap.datafixer.DataFixerHandler;
import com.nomiceu.nomilabs.remap.datafixer.storage.BlockRewriter;
import com.nomiceu.nomilabs.remap.datafixer.storage.BlockStateLike;
import com.nomiceu.nomilabs.remap.datafixer.storage.CompoundRewriter;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.ZipperUtil;

public class LabsRemapHelper {
    public static final Pattern META_ITEM_MATCHER = Pattern.compile("meta_.+");
    public static final Pattern META_BLOCK_MATCHER = Pattern.compile("meta_block_.+_\\d+");
    public static final int MIN_META_ITEM_BASE_ID = 32000;
    public static final int MIN_META_BLOCK_BASE_ID = 2000;
    private static Map<BlockPos, NBTTagCompound> posToTileEntityCache;

    public static void createWorldBackup() {
        try {
            NomiLabs.LOGGER.info("Creating world backup...");
            ZipperUtil.backupWorld();
        }
        catch (Exception e) {
            LabsRemapHelper.abort();
            NomiLabs.LOGGER.error("Error creating backup. Closing...");
            NomiLabs.LOGGER.throwing((Throwable)e);
        }
    }

    public static void rewriteCompoundTags(NBTTagCompound tag, CompoundRewriter rewriter) {
        for (String key : tag.func_150296_c()) {
            NBTBase childTag = tag.func_74781_a(key);
            switch (childTag.func_74732_a()) {
                case 9: {
                    LabsRemapHelper.rewriteCompoundTags((NBTTagList)childTag, rewriter);
                    break;
                }
                case 10: {
                    NBTTagCompound childTagCompound = (NBTTagCompound)childTag;
                    LabsRemapHelper.rewriteCompoundTags(childTagCompound, rewriter);
                    childTagCompound = rewriter.rewrite(childTagCompound);
                    if (childTagCompound == null) break;
                    tag.func_74782_a(key, (NBTBase)childTagCompound);
                }
            }
        }
    }

    public static void rewriteCompoundTags(NBTTagList tag, CompoundRewriter rewriter) {
        block4: for (int i = 0; i < tag.func_74745_c(); ++i) {
            NBTBase childTag = tag.func_179238_g(i);
            switch (childTag.func_74732_a()) {
                case 9: {
                    LabsRemapHelper.rewriteCompoundTags((NBTTagList)childTag, rewriter);
                    continue block4;
                }
                case 10: {
                    NBTTagCompound childTagCompound = (NBTTagCompound)childTag;
                    LabsRemapHelper.rewriteCompoundTags(childTagCompound, rewriter);
                    childTagCompound = rewriter.rewrite(childTagCompound);
                    if (childTagCompound == null) continue block4;
                    tag.func_150304_a(i, (NBTBase)childTagCompound);
                }
            }
        }
    }

    public static void rewriteBlocks(NBTTagCompound compound, BlockRewriter rewriter) {
        LabsRemapHelper.clearTECache();
        NBTTagCompound levelTag = compound.func_74775_l("Level");
        int x = levelTag.func_74762_e("xPos");
        int z = levelTag.func_74762_e("zPos");
        NBTTagList sectionListTag = levelTag.func_150295_c("Sections", 10);
        for (int i = 0; i < sectionListTag.func_74745_c(); ++i) {
            sectionListTag.func_150304_a(i, (NBTBase)LabsRemapHelper.rewriteBlocksInSection(sectionListTag.func_150305_b(i), x, z, rewriter));
        }
        if (posToTileEntityCache != null) {
            NBTTagList tagList = new NBTTagList();
            posToTileEntityCache.values().forEach(arg_0 -> ((NBTTagList)tagList).func_74742_a(arg_0));
            levelTag.func_74782_a("TileEntities", (NBTBase)tagList);
        }
    }

    private static NBTTagCompound rewriteBlocksInSection(NBTTagCompound chunkSectionTag, int chunkX, int chunkZ, BlockRewriter rewriter) {
        byte[] blockIds = chunkSectionTag.func_74770_j("Blocks");
        int chunkY = chunkSectionTag.func_74762_e("Y");
        NibbleArray blockMetadata = new NibbleArray(chunkSectionTag.func_74770_j("Data"));
        NibbleArray extendedIds = chunkSectionTag.func_150297_b("Add", 7) ? new NibbleArray(chunkSectionTag.func_74770_j("Add")) : null;
        for (int i = 0; i < 4096; ++i) {
            BlockStateLike remapped;
            int x = i & 0xF;
            int y = i >> 8 & 0xF;
            int z = i >> 4 & 0xF;
            int id = extendedIds == null ? blockIds[i] & 0xFF : blockIds[i] & 0xFF | extendedIds.func_76582_a(x, y, z) << 8;
            BlockStateLike state = new BlockStateLike(id, (short)blockMetadata.func_76582_a(x, y, z), new BlockPos(chunkX * 16 + x, chunkY * 16 + y, chunkZ * 16 + z));
            if (state.invalid || (remapped = rewriter.rewrite(state)) == null) continue;
            blockIds[i] = (byte)(remapped.getId() & 0xFF);
            int idExt = remapped.getId() >> 8 & 0xF;
            if (idExt != 0) {
                if (extendedIds == null) {
                    extendedIds = new NibbleArray();
                }
                extendedIds.func_76581_a(x, y, z, idExt);
            }
            blockMetadata.func_76581_a(x, y, z, remapped.meta & 0xF);
            if (posToTileEntityCache == null || remapped.tileEntityTag == null) continue;
            posToTileEntityCache.put(remapped.pos, remapped.tileEntityTag);
        }
        if (extendedIds != null) {
            chunkSectionTag.func_74773_a("Add", extendedIds.func_177481_a());
        }
        return chunkSectionTag;
    }

    public static boolean tagHasItemInfo(NBTTagCompound tag) {
        return tag.func_150297_b("id", 8) && tag.func_150297_b("Count", 99) && tag.func_150297_b("Damage", 99);
    }

    public static void clearTECache() {
        posToTileEntityCache = null;
    }

    public static Map<BlockPos, NBTTagCompound> getPosToTileEntityMap(NBTTagCompound chunkTag) {
        if (posToTileEntityCache != null) {
            return posToTileEntityCache;
        }
        posToTileEntityCache = new Object2ObjectLinkedOpenHashMap();
        NBTTagCompound levelTag = chunkTag.func_74775_l("Level");
        NBTTagList tileEntities = levelTag.func_150295_c("TileEntities", 10);
        for (NBTBase te : tileEntities) {
            NBTTagCompound tag = (NBTTagCompound)te;
            posToTileEntityCache.put(new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")), tag);
        }
        return posToTileEntityCache;
    }

    public static int getReportedVersion() {
        return 4 + LabsVersionConfig.manualFixVersion;
    }

    public static void abort() {
        DataFixerHandler.close();
        StartupQuery.abort();
    }
}

