/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.remap;

import com.google.common.collect.ImmutableList;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.remap.LabsMessageHelper;
import com.nomiceu.nomilabs.remap.LabsRemapHelper;
import com.nomiceu.nomilabs.remap.Remapper;
import com.nomiceu.nomilabs.remap.datafixer.DataFixerHandler;
import com.nomiceu.nomilabs.util.LabsNames;
import gregtech.api.util.GTUtility;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LabsRemappers {
    public static Map<Remapper.RemapTypes, List<? extends Remapper>> remappers;
    public static Map<Remapper.RemapTypes, List<Pattern>> ignorePtns;
    public static Map<ResourceLocation, ResourceLocation> deprecationRemap;
    public static Remapper deprecatedRemapper;
    public static Remapper ctRemapper;
    public static Remapper perfectGemRemapper;
    public static Remapper metaBlockRemapper;
    public static Remapper patternEncoderRemapper;
    public static boolean checked;

    public static void preInit() {
        LabsRemappers.helpersInit();
        LabsRemappers.initRemappers();
        LabsRemappers.parseIgnoreConfigs();
    }

    private static void initRemappers() {
        remappers = new Object2ObjectOpenHashMap();
        ObjectArrayList itemRemappers = new ObjectArrayList();
        itemRemappers.add(deprecatedRemapper);
        itemRemappers.add(ctRemapper);
        itemRemappers.add(perfectGemRemapper);
        itemRemappers.add(metaBlockRemapper);
        itemRemappers.add(patternEncoderRemapper);
        remappers.put(Remapper.RemapTypes.ITEM, (List<? extends Remapper>)itemRemappers);
        remappers.put(Remapper.RemapTypes.BLOCK, (List<? extends Remapper>)ImmutableList.of((Object)ctRemapper, (Object)metaBlockRemapper, (Object)patternEncoderRemapper));
    }

    private static void parseIgnoreConfigs() {
        ignorePtns = new Object2ObjectOpenHashMap();
        ignorePtns.put(Remapper.RemapTypes.ITEM, LabsRemappers.parseIgnoreConfig(LabsConfig.advanced.ignoreItems, Remapper.RemapTypes.ITEM));
        ignorePtns.put(Remapper.RemapTypes.BLOCK, LabsRemappers.parseIgnoreConfig(LabsConfig.advanced.ignoreBlocks, Remapper.RemapTypes.BLOCK));
        ignorePtns.put(Remapper.RemapTypes.ENTITY, LabsRemappers.parseIgnoreConfig(LabsConfig.advanced.ignoreEntities, Remapper.RemapTypes.ENTITY));
        ignorePtns.put(Remapper.RemapTypes.BIOME, LabsRemappers.parseIgnoreConfig(LabsConfig.advanced.ignoreBiomes, Remapper.RemapTypes.BIOME));
    }

    private static List<Pattern> parseIgnoreConfig(String[] patterns, Remapper.RemapTypes type) {
        ArrayList<Pattern> ignored = new ArrayList<Pattern>();
        for (String pattern : patterns) {
            try {
                ignored.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                NomiLabs.LOGGER.error("Bad Syntax for Pattern: {} (Type {})", (Object)pattern, (Object)type);
                NomiLabs.LOGGER.throwing((Throwable)e);
            }
        }
        NomiLabs.LOGGER.info("[Remappers]: Parsed Ignore Config: {}, for Type: {}", ignored, (Object)type);
        return ignored;
    }

    private static void helpersInit() {
        deprecationRemap = new Object2ObjectOpenHashMap();
        deprecationRemap.put(new ResourceLocation("contenttweaker", "omnicoin"), LabsNames.makeLabsName("nomicoin"));
        deprecationRemap.put(new ResourceLocation("contenttweaker", "omnicoin5"), LabsNames.makeLabsName("nomicoin5"));
        deprecationRemap.put(new ResourceLocation("contenttweaker", "omnicoin25"), LabsNames.makeLabsName("nomicoin25"));
        deprecationRemap.put(new ResourceLocation("contenttweaker", "omnicoin100"), LabsNames.makeLabsName("nomicoin100"));
        deprecationRemap.put(new ResourceLocation("contenttweaker", "blazepowder"), new ResourceLocation("minecraft", "blaze_powder"));
        deprecationRemap.put(new ResourceLocation("contenttweaker", "dark_red_coal"), new ResourceLocation("extrautils2", "ingredients"));
        deprecatedRemapper = new Remapper(rl -> deprecationRemap.containsKey(rl), rl -> deprecationRemap.get(rl));
        ctRemapper = new Remapper(rl -> rl.func_110624_b().equals("contenttweaker"), rl -> LabsNames.makeLabsName(rl.func_110623_a()));
        perfectGemRemapper = new Remapper(rl -> rl.func_110624_b().equals("devtech") && rl.func_110623_a().equals("meta_gem_perfect"), rl -> GTUtility.gregtechId((String)rl.func_110623_a()));
        metaBlockRemapper = new Remapper(rl -> LabsRemappers.getMetaBlockID(rl) >= 2000, rl -> {
            CharSequence[] split = rl.func_110623_a().split("_");
            split[split.length - 1] = String.valueOf(LabsRemappers.getMetaBlockID(rl) - 2000);
            return LabsNames.makeLabsName(String.join((CharSequence)"_", split));
        });
        patternEncoderRemapper = new Remapper(rl -> rl.func_110624_b().equals("ae2stuff") && rl.func_110623_a().equals("encoder"), rl -> new ResourceLocation("appliedenergistics2", "interface"));
    }

    private static int getMetaBlockID(ResourceLocation rl) {
        if (!LabsRemapHelper.META_BLOCK_MATCHER.matcher(rl.func_110623_a()).matches()) {
            return 0;
        }
        String[] split = rl.func_110623_a().split("_");
        return Integer.parseInt(split[split.length - 1]);
    }

    public static <T extends IForgeRegistryEntry<T>> void remapAndIgnoreEntries(RegistryEvent.MissingMappings<T> event, Remapper.RemapTypes type) {
        RegistryEvent.MissingMappings.Mapping entry;
        int i;
        ImmutableList mappings = event.getAllMappings();
        List<? extends Remapper> remap = remappers.get((Object)type);
        List<Pattern> ptns = ignorePtns.get((Object)type);
        boolean[] ignores = new boolean[mappings.size()];
        boolean needsRemap = false;
        if (remap == null && ptns == null) {
            return;
        }
        block0: for (i = 0; i < mappings.size(); ++i) {
            entry = (RegistryEvent.MissingMappings.Mapping)mappings.get(i);
            if (ptns != null) {
                for (Pattern pattern : ptns) {
                    if (!pattern.matcher(entry.key.toString()).matches()) continue;
                    entry.ignore();
                    NomiLabs.LOGGER.debug("Ignoring Resource Location {} (Type {})", (Object)entry.key, (Object)type);
                    ignores[i] = true;
                    break;
                }
            }
            if (ignores[i] || needsRemap || remap == null) continue;
            for (Remapper remapper : remap) {
                if (!remapper.shouldRemap(entry.key)) continue;
                needsRemap = true;
                continue block0;
            }
        }
        if (!needsRemap) {
            return;
        }
        if (!checked && !DataFixerHandler.checked) {
            LabsMessageHelper.sendMessage(LabsMessageHelper.MessageType.CONFIRM, LabsMessageHelper.Components.getIntro());
            LabsRemapHelper.createWorldBackup();
            checked = true;
        }
        block3: for (i = 0; i < mappings.size(); ++i) {
            if (ignores[i]) continue;
            entry = (RegistryEvent.MissingMappings.Mapping)mappings.get(i);
            for (Remapper remapper : remap) {
                if (!remapper.shouldRemap(entry.key)) continue;
                ResourceLocation oldRl = entry.key;
                NomiLabs.LOGGER.debug("Mapping Resource Location {}... (Type {})", (Object)oldRl, (Object)type);
                ResourceLocation newRl = remapper.remapEntry(entry, type);
                if (newRl == null) {
                    NomiLabs.LOGGER.error("Failed to Map Resource Location {}! (Type {})", (Object)oldRl, (Object)type);
                    continue block3;
                }
                NomiLabs.LOGGER.debug("Mapped Resource Location {} to {}! (Type {})", (Object)oldRl, (Object)newRl, (Object)type);
                continue block3;
            }
        }
    }

    static {
        checked = false;
    }
}

