/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.remap;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Remapper {
    private final Function<ResourceLocation, Boolean> shouldRemap;
    private final Function<ResourceLocation, ResourceLocation> remapRl;

    public Remapper(Function<ResourceLocation, Boolean> shouldRemap, Function<ResourceLocation, ResourceLocation> remapRl) {
        this.shouldRemap = shouldRemap;
        this.remapRl = remapRl;
    }

    public boolean shouldRemap(ResourceLocation rl) {
        return this.shouldRemap.apply(rl);
    }

    public ResourceLocation remapRl(ResourceLocation rl) {
        return this.remapRl.apply(rl);
    }

    @Nullable
    public <T extends IForgeRegistryEntry<T>> ResourceLocation remapEntry(RegistryEvent.MissingMappings.Mapping<T> entry, RemapTypes type) {
        ResourceLocation rl = this.remapRl(entry.key);
        IForgeRegistryEntry remap = new RemapTypes.RegistryHelper().getRegistryForType(type).getValue(rl);
        if (remap == null) {
            return null;
        }
        entry.remap(remap);
        return rl;
    }

    public static enum RemapTypes {
        ITEM,
        BLOCK,
        ENTITY,
        BIOME;


        public static class RegistryHelper<T extends IForgeRegistryEntry<T>> {
            public IForgeRegistry<T> getRegistryForType(RemapTypes type) {
                switch (type) {
                    case ITEM: {
                        return ForgeRegistries.ITEMS;
                    }
                    case BLOCK: {
                        return ForgeRegistries.BLOCKS;
                    }
                    case ENTITY: {
                        return ForgeRegistries.ENTITIES;
                    }
                    case BIOME: {
                        return ForgeRegistries.BIOMES;
                    }
                }
                throw new RuntimeException("No Registry Set for Type " + type.name() + "!");
            }
        }
    }
}

