/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.remap.datafixer;

import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.config.LabsVersionConfig;
import com.nomiceu.nomilabs.mixinhelper.RemappableForgeRegistry;
import com.nomiceu.nomilabs.remap.LabsMessageHelper;
import com.nomiceu.nomilabs.remap.LabsRemapHelper;
import com.nomiceu.nomilabs.remap.datafixer.DataFix;
import com.nomiceu.nomilabs.remap.datafixer.LabsFixes;
import com.nomiceu.nomilabs.remap.datafixer.LabsWorldFixData;
import com.nomiceu.nomilabs.remap.datafixer.fixes.BlockFixer;
import com.nomiceu.nomilabs.remap.datafixer.fixes.ItemFixer;
import com.nomiceu.nomilabs.remap.datafixer.fixes.TileEntityFixer;
import com.nomiceu.nomilabs.remap.datafixer.types.LabsFixTypes;
import com.nomiceu.nomilabs.remap.datafixer.walker.BlockEntityWalker;
import com.nomiceu.nomilabs.remap.datafixer.walker.ChunkWalker;
import com.nomiceu.nomilabs.remap.datafixer.walker.ItemStackWalker;
import io.sommers.packmode.PMConfig;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.world.storage.SaveHandler;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import org.apache.commons.lang3.StringUtils;
import org.apache.groovy.util.Arrays;

public class DataFixerHandler {
    public static LabsWorldFixData worldSavedData = null;
    public static boolean checked = false;
    public static Map<IFixType, List<DataFix<?>>> neededNewFixes;
    public static boolean modeNeeded;
    private static boolean fixAvailable;
    private static String savedLabsVersion;
    private static Map<Integer, ResourceLocation> idToBlockMap;
    private static Map<ResourceLocation, Integer> blockToIdMap;

    public static void preInit() {
        CompoundDataFixer fmlFixer = FMLCommonHandler.instance().getDataFixer();
        ItemStackWalker itemWalker = new ItemStackWalker();
        fmlFixer.func_188255_a((IFixType)FixTypes.ENTITY, (IDataWalker)itemWalker);
        fmlFixer.func_188255_a((IFixType)FixTypes.PLAYER, (IDataWalker)itemWalker);
        fmlFixer.func_188255_a((IFixType)LabsFixTypes.WalkerTypes.ENDER_STORAGE, (IDataWalker)itemWalker);
        fmlFixer.func_188255_a((IFixType)FixTypes.BLOCK_ENTITY, (IDataWalker)new BlockEntityWalker(itemWalker));
        fmlFixer.func_188255_a((IFixType)FixTypes.CHUNK, (IDataWalker)new ChunkWalker());
        ModFixs fixs = fmlFixer.init("nomilabs", LabsRemapHelper.getReportedVersion());
        fixs.registerFix((IFixType)LabsFixTypes.FixerTypes.ITEM, (IFixableData)new ItemFixer());
        fixs.registerFix((IFixType)LabsFixTypes.FixerTypes.CHUNK, (IFixableData)new BlockFixer());
        fixs.registerFix((IFixType)LabsFixTypes.FixerTypes.TILE_ENTITY, (IFixableData)new TileEntityFixer());
    }

    public static void onWorldLoad(SaveHandler save) {
        checked = false;
        modeNeeded = false;
        neededNewFixes = null;
        savedLabsVersion = null;
        fixAvailable = true;
        idToBlockMap = null;
        blockToIdMap = null;
        NomiLabs.LOGGER.info("Checking Data Fixers...");
        DataFixerHandler.getInfoFromSave(save);
        LabsFixes.init();
        File mapFile = save.func_75758_b("nomilabs.fix_data");
        if (mapFile.exists()) {
            worldSavedData = LabsWorldFixData.load(mapFile);
            if (LabsVersionConfig.manualFixVersion < DataFixerHandler.worldSavedData.savedManualFixVersion) {
                NomiLabs.LOGGER.fatal("Manual Data Fix Version has been decremented. This is not supported!");
                LabsMessageHelper.sendMessage(LabsMessageHelper.MessageType.NOTIFY, LabsMessageHelper.Components.getInvalidManualVersion());
                LabsRemapHelper.abort();
            }
            LabsWorldFixData.save(mapFile, worldSavedData);
            if (DataFixerHandler.worldSavedData.savedFixVersion == 4) {
                NomiLabs.LOGGER.info("This world's internal data version is up to date.");
                if (LabsVersionConfig.manualFixVersion != DataFixerHandler.worldSavedData.savedManualFixVersion) {
                    NomiLabs.LOGGER.info("The Manual Data Fix Version has been increased. New Version: {}. Enabling Data Fixers...", (Object)LabsVersionConfig.manualFixVersion);
                }
                worldSavedData = null;
                return;
            }
            NomiLabs.LOGGER.info("This world's internal data version needs updating. New Version: {}.", (Object)4);
        } else {
            worldSavedData = new LabsWorldFixData();
            NomiLabs.LOGGER.info("This world was saved without a data version info. New Version: {}.", (Object)4);
            LabsWorldFixData.save(mapFile, worldSavedData);
        }
        DataFixerHandler.determineNeededFixesAndLog();
        if (neededNewFixes.isEmpty()) {
            NomiLabs.LOGGER.info("This world does not need any new data fixers, but it has no saved version, it is old, or this is a new world.");
            return;
        }
        LabsMessageHelper.sendMessage(LabsMessageHelper.MessageType.CONFIRM, (String[])Arrays.concat((Object[][])new String[][]{LabsMessageHelper.Components.getIntro(), LabsMessageHelper.Components.getIntroAddition()}));
        if (modeNeeded) {
            LabsMessageHelper.sendMessage(LabsMessageHelper.MessageType.CONFIRM, LabsMessageHelper.Components.getModeCheck(StringUtils.capitalize((String)PMConfig.getPackMode())));
        }
        LabsMessageHelper.sendMessage(LabsMessageHelper.MessageType.NOTIFY, LabsMessageHelper.Components.getDoNotExit());
        checked = true;
        LabsRemapHelper.createWorldBackup();
    }

    private static void getInfoFromSave(SaveHandler save) {
        File levelDat = new File(save.func_75765_b(), "level.dat");
        if (!levelDat.exists()) {
            return;
        }
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(levelDat));
            if (!nbt.func_150297_b("FML", 10)) {
                return;
            }
            NBTTagCompound fml = nbt.func_74775_l("FML");
            if (fml.func_150297_b("ModList", 9)) {
                NBTTagList modList = fml.func_150295_c("ModList", 10);
                for (NBTBase mod : modList) {
                    NBTTagCompound compound;
                    if (!(mod instanceof NBTTagCompound) || !(compound = (NBTTagCompound)mod).func_150297_b("ModId", 8) || !compound.func_150297_b("ModVersion", 8) || !"nomilabs".equals(compound.func_74779_i("ModId"))) continue;
                    savedLabsVersion = compound.func_74779_i("ModVersion");
                    return;
                }
            }
        }
        catch (IOException e) {
            NomiLabs.LOGGER.fatal("Failed to read level.dat.", (Throwable)e);
        }
    }

    private static void determineNeededFixesAndLog() {
        neededNewFixes = new Object2ObjectOpenHashMap();
        if ("0.15.1".equals(savedLabsVersion)) {
            return;
        }
        worldSavedData.processSavedLabsVersion(savedLabsVersion);
        NomiLabs.LOGGER.info("NEEDED DATA FIXES: ----------------------------------------");
        for (IFixType fixType : LabsFixes.fixes.keySet()) {
            NomiLabs.LOGGER.info("SECTION: {} -------------------------------------------", (Object)fixType);
            List<DataFix<?>> fixes = LabsFixes.fixes.get(fixType);
            for (DataFix<?> fix : fixes) {
                if (!fix.validVersion.apply(DataFixerHandler.worldSavedData.savedFixVersion).booleanValue()) continue;
                neededNewFixes.computeIfAbsent(fixType, key -> new ObjectArrayList()).add(fix);
                if (fix.needsMode) {
                    modeNeeded = true;
                }
                NomiLabs.LOGGER.info("- {}: {}", (Object)fix.name, (Object)fix.description);
            }
            NomiLabs.LOGGER.info("END SECTION: {}. SEE ABOVE. ^^^^^^^^^^^^^^^^^^^^^^^^^^^", (Object)fixType);
        }
        NomiLabs.LOGGER.info("END NEEDED DATA FIXES. SEE ABOVE. ^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    public static Map<Integer, ResourceLocation> getIdToBlockMap() {
        if (idToBlockMap != null) {
            return idToBlockMap;
        }
        ForgeRegistry registry = (ForgeRegistry)ForgeRegistries.BLOCKS;
        idToBlockMap = registry.getKeys().stream().collect(Collectors.toMap(arg_0 -> ((ForgeRegistry)registry).getID(arg_0), Function.identity()));
        RemappableForgeRegistry remReg = (RemappableForgeRegistry)registry;
        if (!remReg.getRemapped().isEmpty()) {
            NomiLabs.LOGGER.debug("Map Before Adding Remapped IDs:");
            NomiLabs.LOGGER.debug(idToBlockMap);
            NomiLabs.LOGGER.debug("Adding Block Remapped IDs:");
            NomiLabs.LOGGER.debug(remReg.getRemapped());
            idToBlockMap.putAll(remReg.getRemapped());
        }
        NomiLabs.LOGGER.debug("Generated Id to Block Map!");
        NomiLabs.LOGGER.debug(idToBlockMap);
        return idToBlockMap;
    }

    public static Map<ResourceLocation, Integer> getBlockToIdMap() {
        if (blockToIdMap != null) {
            return blockToIdMap;
        }
        ForgeRegistry registry = (ForgeRegistry)ForgeRegistries.BLOCKS;
        blockToIdMap = registry.getKeys().stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((ForgeRegistry)registry).getID(arg_0)));
        NomiLabs.LOGGER.debug("Generated Block To Id Map!");
        NomiLabs.LOGGER.debug(blockToIdMap);
        return blockToIdMap;
    }

    public static void processEnderStorageInfo(DataFixer fixer, SaveHandler save) {
        String[] processFiles;
        NomiLabs.LOGGER.info("Processing Ender Storage Info...");
        File enderStorageDir = new File(save.func_75765_b(), "EnderStorage");
        for (String toProcess : processFiles = new String[]{"data1.dat", "data2.dat"}) {
            File processFile = new File(enderStorageDir, toProcess);
            if (!processFile.isFile()) continue;
            try {
                NBTTagCompound fileNbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(processFile));
                NBTTagCompound newNbt = fixer.func_188257_a((IFixType)LabsFixTypes.WalkerTypes.ENDER_STORAGE, fileNbt);
                FileOutputStream fileOut = new FileOutputStream(processFile);
                CompressedStreamTools.func_74799_a((NBTTagCompound)newNbt, (OutputStream)fileOut);
                NomiLabs.LOGGER.info("Successfully wrote {} Ender Storage Save Data!", (Object)toProcess);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read or write Ender Storage save data!", e);
            }
        }
        NomiLabs.LOGGER.info("Finished Processing Ender Storage Info!");
    }

    public static boolean hasNoNewFixes() {
        return worldSavedData == null || neededNewFixes == null || neededNewFixes.isEmpty();
    }

    public static boolean fixNotAvailable() {
        return !fixAvailable;
    }

    public static void close() {
        worldSavedData = null;
        checked = false;
        fixAvailable = false;
        neededNewFixes = null;
        idToBlockMap = null;
        blockToIdMap = null;
    }

    static {
        modeNeeded = false;
        fixAvailable = false;
    }
}

