/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.remap.datafixer;

import com.google.common.collect.ImmutableMap;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.item.registry.LabsItems;
import com.nomiceu.nomilabs.remap.LabsRemapHelper;
import com.nomiceu.nomilabs.remap.LabsRemappers;
import com.nomiceu.nomilabs.remap.datafixer.DataFix;
import com.nomiceu.nomilabs.remap.datafixer.storage.ItemStackLike;
import com.nomiceu.nomilabs.remap.datafixer.types.LabsFixTypes;
import com.nomiceu.nomilabs.util.LabsModeHelper;
import com.nomiceu.nomilabs.util.LabsNames;
import gregtech.api.GregTechAPI;
import gregtech.api.unification.material.Material;
import gregtech.common.pipelike.cable.Insulation;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.itempipe.ItemPipeType;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.shorts.Short2ShortLinkedOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixType;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.Nullable;

public class LabsFixes {
    public static final String DATA_NAME = "nomilabs.fix_data";
    public static final String DATA_KEY = "LabsFixer";
    public static final int NEW = Integer.MAX_VALUE;
    public static final int CURRENT = 4;
    public static final int PRE_AE2_STUFF_REMAP = 3;
    public static final int PRE_CAPACITOR_REMAPPING = 2;
    public static final int PRE_MATERIAL_REWORK = 1;
    public static final int DEFAULT = 0;
    public static final int DEFAULT_NOMI_CEU = -1;
    public static List<DataFix.ItemFix> itemFixes;
    public static List<DataFix.BlockFix> blockFixes;
    public static List<DataFix.TileEntityFix> tileEntityFixes;
    public static Map<IFixType, List<? extends DataFix<?>>> fixes;
    public static Map<ResourceLocation, ResourceLocation> multiblockMetaIdRemap;
    public static Map<Short, Short> multiblockMetaRemap;
    public static Set<ResourceLocation> specialMetaItemsRemap;
    public static Set<String> materialNames;
    public static Map<String, OldCapacitorSpecification> capacitorSpecificationRemap;

    public static void init() {
        LabsFixes.helpersInit();
        itemFixes = new ObjectArrayList();
        itemFixes.add(new DataFix.ItemFix("Dark Red Coal Remap", "Correctly remaps Content Tweaker Dark Red Coal to XU2 Red Coal.", false, version -> version <= 0, stack -> stack.rl.equals((Object)new ResourceLocation("contenttweaker", "dark_red_coal")), stack -> stack.setRl(new ResourceLocation("extrautils2", "ingredients")).setMeta((short)4)));
        if (Loader.isModLoaded((String)"enderio")) {
            itemFixes.add(new DataFix.ItemFix("Custom Capacitor NBT Removal", "Removes NBT from Custom Capacitors.", false, version -> version <= 2, stack -> (stack.rl.func_110624_b().equals("nomilabs") || stack.rl.func_110624_b().equals("contenttweaker")) && capacitorSpecificationRemap.containsKey(stack.rl.func_110623_a()) && capacitorSpecificationRemap.get(stack.rl.func_110623_a()).needChange(stack.tag), stack -> stack.setTag(capacitorSpecificationRemap.get(stack.rl.func_110623_a()).remove(stack.tag))));
        }
        itemFixes.add(new DataFix.ItemFix("Deprecated Item Remap", "Remaps Deprecated Items to their Modern Counterparts.", false, version -> version <= 0, stack -> LabsRemappers.deprecatedRemapper.shouldRemap(stack.rl), stack -> stack.setRl(LabsRemappers.deprecatedRemapper.remapRl(stack.rl))));
        itemFixes.add(new DataFix.ItemFix("Content Tweaker Item Remap", "Remaps Content Tweaker Items to their counterparts.", false, version -> version <= 0, stack -> LabsRemappers.ctRemapper.shouldRemap(stack.rl), stack -> stack.setRl(LabsRemappers.ctRemapper.remapRl(stack.rl))));
        itemFixes.add(new DataFix.ItemFix("Perfect Gem Item Remap", "Remaps Perfect Gems to their counterparts.", false, version -> version <= 0, stack -> LabsRemappers.perfectGemRemapper.shouldRemap(stack.rl), stack -> stack.setRl(LabsRemappers.perfectGemRemapper.remapRl(stack.rl))));
        if (LabsConfig.modIntegration.enableExtraUtils2Integration) {
            itemFixes.add(new DataFix.ItemFix("XU2 Frequency Removal", "Removes Frequency from XU2 Ingredients.", false, version -> version <= 0 || version == Integer.MAX_VALUE, stack -> stack.rl.equals((Object)new ResourceLocation("extrautils2", "ingredients")) && stack.tag != null && stack.tag.func_74764_b("Freq"), stack -> {
                NBTTagCompound tag = Objects.requireNonNull(stack.tag);
                tag.func_82580_o("Freq");
                stack.setTag(tag);
            }));
        }
        itemFixes.add(new DataFix.ItemFix("Old Multiblock Metadata Remap", "Remaps old Multiblock Metadata to the new format.", true, version -> version <= -1, stack -> stack.rl.equals((Object)new ResourceLocation("gregtech", "machine")) && multiblockMetaRemap.containsKey(stack.meta), stack -> stack.setMeta(multiblockMetaRemap.get(stack.meta))));
        itemFixes.add(new DataFix.ItemFix("Material Meta Item Remap", "Remaps old Meta Items, from Custom Materials, to the new format and registry.", false, version -> version <= 1, stack -> stack.rl.func_110624_b().equals("gregtech") && LabsRemapHelper.META_ITEM_MATCHER.matcher(stack.rl.func_110623_a()).matches() && !LabsRemapHelper.META_BLOCK_MATCHER.matcher(stack.rl.func_110623_a()).matches() && stack.meta >= 32000, stack -> stack.setMeta((short)(stack.meta - 32000)).setRl(LabsNames.makeLabsName(stack.rl.func_110623_a()))));
        itemFixes.add(new DataFix.ItemFix("Material Meta Blocks' Item Forms Remap", "Remaps old Meta Blocks' Item Forms, from Custom Materials, to the new format and registry.", false, version -> version <= 1, stack -> LabsRemappers.metaBlockRemapper.shouldRemap(stack.rl), stack -> stack.setRl(LabsRemappers.metaBlockRemapper.remapRl(stack.rl))));
        itemFixes.add(new DataFix.ItemFix("Material Special Meta Item Remap", "Remaps old special placeable Meta Items, from Custom Materials, to the new format and registry.", false, version -> version <= 1, stack -> specialMetaItemsRemap.contains(stack.rl) && stack.meta >= 32000, stack -> stack.setMeta((short)(stack.meta - 32000)).setRl(LabsNames.makeLabsName(stack.rl.func_110623_a()))));
        if (Loader.isModLoaded((String)"ae2stuff")) {
            itemFixes.add(new DataFix.ItemFix("AE2 Stuff Pattern Encoder Remap", "Remaps AE2 Stuff Pattern Encoders, which were removed in AE2 Stuff Unofficial, to AE2 Interfaces.", false, version -> version <= 3 || version == Integer.MAX_VALUE, stack -> stack.rl.func_110624_b().equals("ae2stuff") && stack.rl.func_110623_a().equals("encoder"), stack -> stack.setRl(new ResourceLocation("appliedenergistics2", "interface"))));
        }
        blockFixes = new ObjectArrayList();
        blockFixes.add(new DataFix.BlockFix("Material Special Meta Block Remap", "Remaps old special placeable Meta Blocks, from Custom Materials, to the new format and registry.", false, version -> version <= 1, true, state -> specialMetaItemsRemap.contains(state.rl), state -> state.tileEntityTag != null && specialMetaItemsRemap.contains(new ResourceLocation(state.tileEntityTag.func_74779_i("PipeBlock"))) && materialNames.contains(state.tileEntityTag.func_74779_i("PipeMaterial")), state -> {
            state.setRl(LabsNames.makeLabsName(state.rl.func_110623_a()));
            state.tileEntityTag.func_74778_a("PipeBlock", LabsNames.makeLabsName(new ResourceLocation(state.tileEntityTag.func_74779_i("PipeBlock")).func_110623_a()).toString());
        }));
        if (Loader.isModLoaded((String)"ae2stuff")) {
            blockFixes.add(new DataFix.BlockFix("AE2 Stuff Pattern Encoder Remap", "Remaps AE2 Stuff Pattern Encoders, which were removed in AE2 Stuff Unofficial, to AE2 Interfaces.", false, version -> version <= 3 || version == Integer.MAX_VALUE, true, state -> state.rl.func_110624_b().equals("appliedenergistics2") && state.rl.func_110623_a().equals("interface") && state.meta != 0, null, state -> {
                state.setMeta((short)0);
                if (state.tileEntityTag == null || !state.tileEntityTag.func_74779_i("id").equals(new ResourceLocation("ae2stuff", "encoder").toString())) {
                    return;
                }
                state.tileEntityTag.func_74778_a("id", new ResourceLocation("appliedenergistics2", "interface").toString());
                state.tileEntityTag.func_74757_a("omniDirectional", true);
                state.tileEntityTag.func_74778_a("customName", "Replaced Pattern Encoder");
                NBTTagCompound patternTag = null;
                if (!state.tileEntityTag.func_150295_c("Items", 10).func_82582_d()) {
                    NBTTagList tagList = state.tileEntityTag.func_150295_c("Items", 10);
                    state.tileEntityTag.func_82580_o("Items");
                    for (NBTBase slotBase : tagList) {
                        NBTTagCompound slotTag;
                        if (slotBase.func_82582_d() || !(slotBase instanceof NBTTagCompound) || !(slotTag = (NBTTagCompound)slotBase).func_150297_b("Slot", 99) || !LabsRemapHelper.tagHasItemInfo(slotTag)) continue;
                        byte slot = slotTag.func_74771_c("Slot");
                        ItemStackLike item = new ItemStackLike(slotTag);
                        if (slot != 10 || !item.rl.func_110624_b().equals("appliedenergistics2") || !item.rl.func_110623_a().equals("material") || item.meta != 52 || item.count <= 0) continue;
                        patternTag = slotTag;
                        break;
                    }
                }
                NBTTagCompound patterns = new NBTTagCompound();
                NBTTagList patternItems = new NBTTagList();
                if (patternTag != null) {
                    patternTag.func_74768_a("Slot", 0);
                    patternItems.func_74742_a(patternTag);
                }
                NBTTagCompound infoTag = new ItemStack((Item)LabsItems.INFO_ITEM, 1, 1).func_77955_b(new NBTTagCompound());
                infoTag.func_74768_a("Slot", patternItems.field_74747_a.size());
                patternItems.func_74742_a((NBTBase)infoTag);
                patterns.func_74782_a("Items", (NBTBase)patternItems);
                state.tileEntityTag.func_74782_a("patterns", (NBTBase)patterns);
            }));
        }
        tileEntityFixes = new ObjectArrayList();
        tileEntityFixes.add(new DataFix.TileEntityFix("Old Multiblock Tile Entity Meta ID Remap", "Remaps old Multiblock Tile Entity Names to the new format.", false, version -> version <= -1, compound -> compound.func_150297_b("MetaId", 8) && compound.func_150297_b("id", 8) && compound.func_74779_i("id").equals(new ResourceLocation("gregtech", "machine").toString()) && multiblockMetaIdRemap.containsKey(new ResourceLocation(compound.func_74779_i("MetaId"))), compound -> compound.func_74778_a("MetaId", multiblockMetaIdRemap.get(new ResourceLocation(compound.func_74779_i("MetaId"))).toString())));
        fixes = new Object2ObjectOpenHashMap();
        fixes.put(LabsFixTypes.FixerTypes.ITEM, itemFixes);
        fixes.put(LabsFixTypes.FixerTypes.CHUNK, blockFixes);
        fixes.put(LabsFixTypes.FixerTypes.TILE_ENTITY, tileEntityFixes);
    }

    private static void helpersInit() {
        specialMetaItemsRemap = new HashSet<ResourceLocation>();
        for (Insulation insulation : Insulation.VALUES) {
            specialMetaItemsRemap.add(new ResourceLocation("gregtech", insulation.func_176610_l()));
        }
        for (Insulation insulation : FluidPipeType.VALUES) {
            specialMetaItemsRemap.add(new ResourceLocation("gregtech", String.format("fluid_pipe_%s", insulation.name)));
        }
        for (Insulation insulation : ItemPipeType.VALUES) {
            specialMetaItemsRemap.add(new ResourceLocation("gregtech", String.format("item_pipe_%s", insulation.name)));
        }
        materialNames = GregTechAPI.materialManager.getRegistry("nomilabs").getAllMaterials().stream().map(Material::getName).collect(Collectors.toSet());
        multiblockMetaRemap = new Short2ShortLinkedOpenHashMap();
        multiblockMetaRemap.put((short)32000, (short)32100);
        multiblockMetaRemap.put((short)32001, (short)32101);
        multiblockMetaRemap.put((short)32002, (short)32102);
        if (LabsModeHelper.isNormal()) {
            multiblockMetaRemap.put((short)32003, (short)32103);
            multiblockMetaRemap.put((short)32004, (short)32104);
            multiblockMetaRemap.put((short)32005, (short)32105);
            multiblockMetaRemap.put((short)3100, (short)32108);
        }
        if (LabsModeHelper.isExpert()) {
            multiblockMetaRemap.put((short)32003, (short)32104);
            multiblockMetaRemap.put((short)32004, (short)32105);
            multiblockMetaRemap.put((short)32005, (short)32106);
            multiblockMetaRemap.put((short)32006, (short)32107);
        }
        multiblockMetaIdRemap = new Object2ObjectLinkedOpenHashMap();
        multiblockMetaIdRemap.put(new ResourceLocation("mbt", "microverse_projector_basic"), LabsNames.makeLabsName("microverse_projector_1"));
        multiblockMetaIdRemap.put(new ResourceLocation("mbt", "microverse_projector_advanced"), LabsNames.makeLabsName("microverse_projector_2"));
        multiblockMetaIdRemap.put(new ResourceLocation("mbt", "microverse_projector_advanced_ii"), LabsNames.makeLabsName("microverse_projector_3"));
        multiblockMetaIdRemap.put(new ResourceLocation("mbt", "creative_tank_provider"), LabsNames.makeLabsName("creative_tank_provider"));
        multiblockMetaIdRemap.put(new ResourceLocation("multiblocktweaker", "naquadah_reactor_1"), LabsNames.makeLabsName("naquadah_reactor_1"));
        multiblockMetaIdRemap.put(new ResourceLocation("multiblocktweaker", "naquadah_reactor_2"), LabsNames.makeLabsName("naquadah_reactor_2"));
        multiblockMetaIdRemap.put(new ResourceLocation("multiblocktweaker", "actualization_chamber"), LabsNames.makeLabsName("actualization_chamber"));
        multiblockMetaIdRemap.put(new ResourceLocation("multiblocktweaker", "universal_crystallizer"), LabsNames.makeLabsName("universal_crystallizer"));
        multiblockMetaIdRemap.put(new ResourceLocation("multiblocktweaker", "dml_sim_chamber"), LabsNames.makeLabsName("dme_sim_chamber"));
        capacitorSpecificationRemap = ImmutableMap.of((Object)"compressedoctadiccapacitor", (Object)new OldCapacitorSpecification(4.0f, "Compressed Octadic RF Capacitor", new String[]{"This is what is known as a Compressed Octadic Capacitor.", "Or, you could just call this an Octadic Capacitor Two.", "Can be inserted into EnderIO machines.", "Level: 4"}), (Object)"doublecompressedoctadiccapacitor", (Object)new OldCapacitorSpecification(5.0f, "Double Compressed Octadic RF Capacitor", new String[]{"AND THIS IS TO GO EVEN FURTHER BEYOND!", "Can be inserted into EnderIO machines.", "Level: 9.001", "Just kidding, it's only 5."}));
    }

    public static class OldCapacitorSpecification {
        private static final String EIO_KEY = "eiocap";
        private static final String EIO_LEVEL_KEY = "level";
        private static final String DISPLAY_KEY = "display";
        private static final String NAME_KEY = "Name";
        private static final String LORE_KEY = "Lore";
        private final float level;
        private final String name;
        private final String[] lore;

        private OldCapacitorSpecification(float level, String name, String ... lore) {
            this.level = level;
            this.name = name;
            this.lore = lore;
        }

        public boolean needChange(@Nullable NBTTagCompound compound) {
            if (compound == null || compound.func_82582_d()) {
                return false;
            }
            return this.testEIO(compound) || this.testName(compound) || this.testLore(compound);
        }

        @Nullable
        public NBTTagCompound remove(@Nullable NBTTagCompound compound) {
            if (compound == null || compound.func_82582_d()) {
                return null;
            }
            this.removeEIO(compound);
            this.removeDisplay(compound);
            return compound;
        }

        private void removeEIO(NBTTagCompound compound) {
            if (!this.testEIO(compound)) {
                return;
            }
            NBTTagCompound eio = compound.func_74775_l(EIO_KEY);
            eio.func_82580_o(EIO_LEVEL_KEY);
            if (eio.func_82582_d()) {
                compound.func_82580_o(EIO_KEY);
            } else {
                compound.func_74782_a(EIO_KEY, (NBTBase)eio);
            }
        }

        private boolean testEIO(NBTTagCompound compound) {
            if (!compound.func_150297_b(EIO_KEY, 10)) {
                return false;
            }
            NBTTagCompound eio = compound.func_74775_l(EIO_KEY);
            if (!eio.func_150297_b(EIO_LEVEL_KEY, 5)) {
                return false;
            }
            return eio.func_74760_g(EIO_LEVEL_KEY) == this.level;
        }

        private void removeDisplay(NBTTagCompound compound) {
            if (!compound.func_150297_b(DISPLAY_KEY, 10)) {
                return;
            }
            NBTTagCompound display = compound.func_74775_l(DISPLAY_KEY);
            if (this.testName(compound)) {
                display.func_82580_o(NAME_KEY);
            }
            if (this.testLore(compound)) {
                display.func_82580_o(LORE_KEY);
            }
            if (display.func_82582_d()) {
                compound.func_82580_o(DISPLAY_KEY);
            } else {
                compound.func_74782_a(DISPLAY_KEY, (NBTBase)display);
            }
        }

        private boolean testName(NBTTagCompound compound) {
            if (!compound.func_150297_b(DISPLAY_KEY, 10)) {
                return false;
            }
            NBTTagCompound display = compound.func_74775_l(DISPLAY_KEY);
            if (!display.func_150297_b(NAME_KEY, 8)) {
                return false;
            }
            return display.func_74779_i(NAME_KEY).equals(this.name);
        }

        private boolean testLore(NBTTagCompound compound) {
            if (!compound.func_150297_b(DISPLAY_KEY, 10)) {
                return false;
            }
            NBTTagCompound display = compound.func_74775_l(DISPLAY_KEY);
            if (!display.func_150297_b(LORE_KEY, 9)) {
                return false;
            }
            NBTTagList lore = display.func_150295_c(LORE_KEY, 8);
            for (int i = 0; i < lore.field_74747_a.size(); ++i) {
                NBTTagString tagStr = (NBTTagString)lore.field_74747_a.get(i);
                String str = tagStr.func_150285_a_();
                if (str.equals(this.lore[i])) continue;
                return false;
            }
            return true;
        }
    }
}

