/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.remap.datafixer;

import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.config.LabsVersionConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.WorldSavedData;
import org.jetbrains.annotations.NotNull;

public class LabsWorldFixData
extends WorldSavedData {
    public int savedFixVersion;
    public int savedManualFixVersion;
    public static final String BASE_DATA_KEY = "data";
    public static final String VERSION_KEY = "Version";
    public static final String MANUAL_VERSION_KEY = "ManualVersion";

    public LabsWorldFixData() {
        super("nomilabs.fix_data");
        this.savedFixVersion = LabsConfig.advanced.enableNomiCEuDataFixes ? -1 : 0;
        this.savedManualFixVersion = 0;
    }

    public void processSavedLabsVersion(String savedLabsVersion) {
        if (savedLabsVersion == null && this.savedFixVersion == 0) {
            this.savedFixVersion = Integer.MAX_VALUE;
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (nbt.func_150297_b(VERSION_KEY, 99)) {
            this.savedFixVersion = nbt.func_74762_e(VERSION_KEY);
            NomiLabs.LOGGER.info("This world was previously loaded with Fix Version {}.", (Object)this.savedFixVersion);
        } else {
            NomiLabs.LOGGER.warn("This world was previously loaded without a saved Fix Version, possibly due to corruption, defaulting to {}.", (Object)this.savedFixVersion);
        }
        if (nbt.func_150297_b(MANUAL_VERSION_KEY, 99)) {
            this.savedManualFixVersion = nbt.func_74762_e(MANUAL_VERSION_KEY);
            NomiLabs.LOGGER.info("This world was previously loaded with Manual Fix Version {}.", (Object)this.savedManualFixVersion);
        } else {
            NomiLabs.LOGGER.info("This world was saved without a Manual Fix Version. Defaulting to {}.", (Object)this.savedManualFixVersion);
        }
    }

    @NotNull
    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a(VERSION_KEY, 4);
        compound.func_74768_a(MANUAL_VERSION_KEY, LabsVersionConfig.manualFixVersion);
        return compound;
    }

    public static LabsWorldFixData load(File mapStorageFile) {
        NBTTagCompound tag = LabsWorldFixData.getDataCompoundOrNew(mapStorageFile);
        LabsWorldFixData data = new LabsWorldFixData();
        data.func_76184_a(tag.func_74775_l("LabsFixer"));
        return data;
    }

    public static void save(File mapStorageFile, LabsWorldFixData data) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound dataTag = mapStorageFile.isFile() ? LabsWorldFixData.getDataCompoundOrNew(mapStorageFile) : new NBTTagCompound();
        dataTag.func_74782_a("LabsFixer", (NBTBase)data.func_189551_b(new NBTTagCompound()));
        tag.func_74782_a(BASE_DATA_KEY, (NBTBase)dataTag);
        try (FileOutputStream mapStorageOut = new FileOutputStream(mapStorageFile);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)mapStorageOut);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write Nomi Labs save fix data!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static NBTTagCompound getDataCompoundOrNew(File mapStorageFile) {
        try (FileInputStream mapStorageIn = new FileInputStream(mapStorageFile);){
            NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)mapStorageIn).func_74775_l(BASE_DATA_KEY);
            if (tag.func_150297_b("LabsFixer", 10)) {
                NBTTagCompound nBTTagCompound = tag;
                return nBTTagCompound;
            }
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            return nBTTagCompound;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read Nomi Labs saved fix data!", e);
        }
    }
}

