/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.remap.datafixer.fixes;

import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.remap.LabsRemapHelper;
import com.nomiceu.nomilabs.remap.datafixer.DataFix;
import com.nomiceu.nomilabs.remap.datafixer.LabsFixes;
import com.nomiceu.nomilabs.remap.datafixer.storage.BlockStateLike;
import com.nomiceu.nomilabs.remap.datafixer.types.LabsFixTypes;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.IFixableData;
import org.jetbrains.annotations.NotNull;

public class BlockFixer
implements IFixableData {
    public int func_188216_a() {
        return LabsRemapHelper.getReportedVersion();
    }

    @NotNull
    public NBTTagCompound func_188217_a(@NotNull NBTTagCompound compound) {
        List<? extends DataFix<?>> blockFixes = LabsFixes.fixes.get((Object)LabsFixTypes.FixerTypes.CHUNK);
        LabsRemapHelper.rewriteBlocks(compound, state -> {
            for (DataFix fix : blockFixes) {
                if (!(fix instanceof DataFix.BlockFix)) continue;
                DataFix.BlockFix blockFix = (DataFix.BlockFix)fix;
                if (!((Boolean)blockFix.validEntry.apply(state)).booleanValue()) continue;
                if (blockFix.teNeeded) {
                    state.setTileEntityTag(LabsRemapHelper.getPosToTileEntityMap(compound).get(state.pos));
                }
                if (blockFix.secondaryValidEntry != null && !blockFix.secondaryValidEntry.apply(state).booleanValue()) continue;
                BlockStateLike oldState = state.copy();
                blockFix.transform.accept(state);
                NomiLabs.LOGGER.debug("[Data Fixer] Changed Block: {} @ {} to {} @ {} at Pos: {}. (ID: {} to {})", (Object)oldState.rl, (Object)oldState.meta, (Object)state.rl, (Object)state.meta, (Object)state.pos, (Object)state.getOldId(), (Object)state.getId());
                if (!blockFix.teNeeded) continue;
                NomiLabs.LOGGER.debug("[Data Fixer] Changed Tile Entity With Above Block: {} to {}.", (Object)oldState.tileEntityTag, (Object)state.tileEntityTag);
            }
            return state;
        });
        return compound;
    }
}

