/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.remap.datafixer.storage;

import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.remap.datafixer.DataFixerHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class BlockStateLike {
    private final int oldId;
    public ResourceLocation rl;
    public short meta;
    public boolean invalid;
    public final BlockPos pos;
    @Nullable
    public NBTTagCompound tileEntityTag;

    public BlockStateLike(int id, short meta, BlockPos pos) {
        this.pos = pos;
        this.rl = DataFixerHandler.getIdToBlockMap().getOrDefault(id, null);
        this.invalid = this.rl == null;
        this.meta = (short)Math.max(0, meta);
        this.oldId = id;
    }

    private BlockStateLike(int oldId, ResourceLocation rl, short meta, boolean invalid, BlockPos pos, @Nullable NBTTagCompound tileEntityTag) {
        this.rl = rl;
        this.meta = meta;
        this.invalid = invalid;
        this.pos = pos;
        this.tileEntityTag = tileEntityTag;
        this.oldId = oldId;
    }

    public BlockStateLike setRl(ResourceLocation newRl) {
        this.rl = newRl;
        return this;
    }

    public BlockStateLike setMeta(short newMeta) {
        this.meta = newMeta;
        return this;
    }

    public BlockStateLike setTileEntityTag(@Nonnull NBTTagCompound tag) {
        this.tileEntityTag = tag;
        return this;
    }

    public int getOldId() {
        return this.oldId;
    }

    public int getId() {
        if (this.rl == null || !DataFixerHandler.getBlockToIdMap().containsKey(this.rl)) {
            NomiLabs.LOGGER.debug("[Data Fixer] Block at Pos {} has Resource Location {}, which is not registered.", (Object)this.rl, (Object)this.pos);
            NomiLabs.LOGGER.debug("[Data Fixer] Most likely, this indicates removed blocks. If the Resource Location is null, report this to Nomi-CEu/Nomi-Labs Devs.");
            return this.oldId;
        }
        return DataFixerHandler.getBlockToIdMap().getOrDefault(this.rl, this.oldId);
    }

    public BlockStateLike copy() {
        return new BlockStateLike(this.oldId, this.rl, this.meta, this.invalid, this.pos, this.tileEntityTag != null ? this.tileEntityTag.func_74737_b() : null);
    }
}

