/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.tooltip;

import com.jaquadro.minecraft.storagedrawers.item.ItemCompDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.tooltip.LabsTooltipHelper;
import com.nomiceu.nomilabs.util.ItemMeta;
import com.nomiceu.nomilabs.util.LabsTranslate;
import eutros.framedcompactdrawers.item.ItemControllerCustom;
import eutros.framedcompactdrawers.item.ItemSlaveCustom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;

public class DrawerTooltipAdder {
    public static void addDrawerInfo(List<String> tooltip, ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemDrawers) && !(stack.func_77973_b() instanceof ItemCompDrawers) || stack.func_77973_b() instanceof ItemControllerCustom || stack.func_77973_b() instanceof ItemSlaveCustom) {
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return;
        }
        boolean shouldPrintShiftMsg = false;
        if (nbt.func_74764_b("tile")) {
            shouldPrintShiftMsg = DrawerTooltipAdder.addDrawerTileInfo(tooltip, nbt);
        } else if (nbt.func_74764_b("labs_saved_upgrades")) {
            shouldPrintShiftMsg = DrawerTooltipAdder.addDrawerUpgradeInfo(tooltip, nbt);
        }
        if (shouldPrintShiftMsg) {
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.drawers.shift", new Object[0]));
        }
    }

    private static boolean addDrawerTileInfo(List<String> tooltip, NBTTagCompound compound) {
        if (!tooltip.isEmpty()) {
            String line;
            int i;
            String target = TextFormatting.YELLOW + LabsTranslate.translate("storagedrawers.drawers.sealed", new Object[0]);
            ArrayList<String> removed = new ArrayList<String>();
            for (i = tooltip.size() - 1; i >= 0 && !(line = tooltip.remove(i)).equals(target); --i) {
                removed.add(line);
            }
            if (!removed.isEmpty()) {
                for (i = removed.size() - 1; i >= 0; --i) {
                    tooltip.add((String)removed.get(i));
                }
            }
        }
        boolean result = DrawerTooltipAdder.addDrawerTileUpgradeInfo(tooltip, compound);
        result = DrawerTooltipAdder.addDrawerStoredInfo(tooltip, compound) || result;
        return result;
    }

    private static boolean addDrawerTileUpgradeInfo(List<String> tooltip, NBTTagCompound compound) {
        NBTTagList upgrades = compound.func_74775_l("tile").func_150295_c("Upgrades", 10);
        if (upgrades.func_82582_d()) {
            return false;
        }
        if (!LabsTooltipHelper.isShiftDown()) {
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.drawers.upgrades", new Object[0]));
            return true;
        }
        tooltip.add(LabsTranslate.translate("tooltip.nomilabs.drawers.upgrades_active", new Object[0]));
        DrawerTooltipAdder.addDrawerUpgrades(tooltip, upgrades);
        return false;
    }

    private static boolean addDrawerStoredInfo(List<String> tooltip, NBTTagCompound compound) {
        NBTTagCompound comp;
        NBTTagList list;
        NBTBase drawers = compound.func_74775_l("tile").func_74781_a("Drawers");
        if (drawers == null || drawers.func_82582_d()) {
            return false;
        }
        if (drawers instanceof NBTTagList && (list = (NBTTagList)drawers).func_179238_g(0).func_82582_d()) {
            return false;
        }
        if (drawers instanceof NBTTagCompound && (comp = (NBTTagCompound)drawers).func_74762_e("Count") <= 0) {
            return false;
        }
        if (!LabsTooltipHelper.isShiftDown()) {
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.drawers.stored", new Object[0]));
            return true;
        }
        tooltip.add(LabsTranslate.translate("tooltip.nomilabs.drawers.stored_active", new Object[0]));
        if (drawers instanceof NBTTagCompound) {
            NBTTagCompound comp2 = (NBTTagCompound)drawers;
            DrawerTooltipAdder.addCompactingDrawerStored(tooltip, comp2);
        } else if (drawers instanceof NBTTagList) {
            NBTTagList list2 = (NBTTagList)drawers;
            DrawerTooltipAdder.addNormalDrawerStored(tooltip, list2);
        } else {
            NomiLabs.LOGGER.fatal("Unknown stored drawer info of type: {} ({})", (Object)drawers.func_74732_a(), (Object)drawers.getClass().getName());
        }
        return false;
    }

    private static void addNormalDrawerStored(List<String> tooltip, NBTTagList drawers) {
        for (NBTBase each : drawers) {
            NBTTagCompound compound = (NBTTagCompound)each;
            int count = compound.func_74762_e("Count");
            ItemStack stack = new ItemStack(compound.func_74775_l("Item"));
            if (stack.func_190926_b()) continue;
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.drawers.item", stack.func_82833_r(), count));
        }
    }

    private static void addCompactingDrawerStored(List<String> tooltip, NBTTagCompound drawers) {
        int count = drawers.func_74762_e("Count");
        NBTTagList items = drawers.func_150295_c("Items", 10);
        for (NBTBase each : items) {
            ItemStack stack;
            int amount;
            NBTTagCompound compound = (NBTTagCompound)each;
            int conv = compound.func_74762_e("Conv");
            if (conv <= 0 || (amount = count / conv) <= 0 || (stack = new ItemStack(compound.func_74775_l("Item"))).func_190926_b()) continue;
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.drawers.item", stack.func_82833_r(), amount));
        }
    }

    private static boolean addDrawerUpgradeInfo(List<String> tooltip, NBTTagCompound compound) {
        NBTTagList list = compound.func_74775_l("labs_saved_upgrades").func_150295_c("Upgrades", 10);
        if (list.func_82582_d()) {
            return false;
        }
        if (!LabsTooltipHelper.isShiftDown()) {
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.drawers.upgrades", new Object[0]));
            return true;
        }
        tooltip.add(LabsTranslate.translate("tooltip.nomilabs.drawers.upgrades_active", new Object[0]));
        DrawerTooltipAdder.addDrawerUpgrades(tooltip, list);
        return false;
    }

    private static void addDrawerUpgrades(List<String> tooltip, NBTTagList list) {
        HashMap<ItemMeta, Integer> upgrades = new HashMap<ItemMeta, Integer>(7);
        for (NBTBase each : list) {
            ItemStack stack = new ItemStack((NBTTagCompound)each);
            if (stack.func_190926_b()) continue;
            ItemMeta meta = new ItemMeta(stack);
            int currValue = upgrades.getOrDefault(meta, 0);
            upgrades.put(meta, currValue + 1);
        }
        for (Map.Entry upgrade : upgrades.entrySet()) {
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.drawers.item", ((ItemMeta)upgrade.getKey()).toStack().func_82833_r(), upgrade.getValue()));
        }
    }
}

