/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.tooltip;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.nomiceu.nomilabs.util.ItemMeta;
import com.nomiceu.nomilabs.util.LabsTranslate;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

@GroovyBlacklist
public class LabsTooltipHelper {
    private static final Map<ItemMeta, List<LabsTranslate.Translatable>> TOOLTIPS = new Object2ObjectOpenHashMap();

    public static boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean isCtrlDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static void addTooltip(ItemMeta itemMeta, List<LabsTranslate.Translatable> tr) {
        if (TOOLTIPS.containsKey(itemMeta)) {
            TOOLTIPS.get(itemMeta).addAll(tr);
        } else {
            TOOLTIPS.put(itemMeta, tr);
        }
    }

    public static void clearAll() {
        TOOLTIPS.clear();
    }

    @Nullable
    public static List<String> getTranslatableFromStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        ItemMeta itemMeta = new ItemMeta(stack);
        if (!TOOLTIPS.containsKey(itemMeta)) {
            return null;
        }
        return TOOLTIPS.get(itemMeta).stream().map(LabsTranslate.Translatable::translate).collect(Collectors.toList());
    }
}

