/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.tooltip;

import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.groovy.NBTClearingRecipe;
import com.nomiceu.nomilabs.tooltip.DrawerTooltipAdder;
import com.nomiceu.nomilabs.tooltip.LabsTooltipHelper;
import com.nomiceu.nomilabs.util.ItemMeta;
import com.nomiceu.nomilabs.util.LabsTranslate;
import crazypants.enderio.api.capacitor.CapabilityCapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.CapacitorKey;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public class TooltipAdder {
    public static void addTooltipNormal(List<String> tooltip, ItemStack stack) {
        List<String> groovyTooltips;
        if (Loader.isModLoaded((String)"storagedrawers")) {
            DrawerTooltipAdder.addDrawerInfo(tooltip, stack);
        }
        if ((groovyTooltips = LabsTooltipHelper.getTranslatableFromStack(stack)) != null) {
            tooltip.addAll(groovyTooltips);
        }
        if (Loader.isModLoaded((String)"enderio") && LabsConfig.modIntegration.enableEnderIOIntegration) {
            TooltipAdder.addTooltipEIO(tooltip, stack);
        }
    }

    public static void addTooltipClearing(List<String> tooltip, ItemStack stack, EntityPlayer player) {
        if (player == null) {
            return;
        }
        InventoryCrafting inv = null;
        InventoryCraftResult result = null;
        if (player.field_71070_bA instanceof ContainerWorkbench) {
            inv = ((ContainerWorkbench)player.field_71070_bA).field_75162_e;
            result = ((ContainerWorkbench)player.field_71070_bA).field_75160_f;
        } else if (player.field_71070_bA instanceof ContainerPlayer) {
            inv = ((ContainerPlayer)player.field_71070_bA).field_75181_e;
            result = ((ContainerPlayer)player.field_71070_bA).field_75179_f;
        }
        if (inv == null || result == null) {
            return;
        }
        ItemStack resultStack = result.func_70301_a(0);
        if (IngredientHelper.isEmpty((ItemStack)resultStack) || resultStack != stack) {
            return;
        }
        ItemMeta resultItemMeta = new ItemMeta(resultStack);
        if (!NBTClearingRecipe.NBT_CLEARERS.containsKey(resultItemMeta)) {
            return;
        }
        Map<ItemMeta, LabsTranslate.Translatable> inputTooltips = NBTClearingRecipe.NBT_CLEARERS.get(resultItemMeta);
        ItemMeta input = TooltipAdder.isNBTClearing(inv, inputTooltips);
        if (input != null) {
            tooltip.add(inputTooltips.get(input).translate());
        }
    }

    @Nullable
    private static ItemMeta isNBTClearing(InventoryCrafting inv, Map<ItemMeta, LabsTranslate.Translatable> pairs) {
        ItemMeta found = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (found != null) {
                return null;
            }
            ItemMeta itemMeta = new ItemMeta(stack);
            if (pairs.containsKey(itemMeta)) {
                found = itemMeta;
                continue;
            }
            return null;
        }
        return found;
    }

    @Optional.Method(modid="enderio")
    private static void addTooltipEIO(List<String> tooltip, ItemStack stack) {
        if (stack.hasCapability(CapabilityCapacitorData.getCapNN(), null)) {
            if (!SpecialTooltipHandler.showAdvancedTooltips()) {
                return;
            }
            ICapacitorData cap = Objects.requireNonNull((ICapacitorData)stack.getCapability(CapabilityCapacitorData.getCapNN(), null));
            float level = cap.getUnscaledValue((ICapacitorKey)CapacitorKey.NO_POWER);
            DecimalFormat formatter = new DecimalFormat("0.##");
            formatter.setRoundingMode(RoundingMode.HALF_UP);
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.capacitors.level", formatter.format(level)));
        }
    }
}

