/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.util;

import com.nomiceu.nomilabs.config.LabsConfig;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class LabsModeHelper {
    private static boolean checked = false;
    private static boolean postInitPassed = false;
    @Nullable
    private static String modePreCache = null;

    public static boolean isNormal() {
        return LabsModeHelper.getMode().equals("normal");
    }

    public static boolean isExpert() {
        return LabsModeHelper.getMode().equals("expert");
    }

    public static String getFormattedMode() {
        return LabsModeHelper.formatMode(LabsModeHelper.getMode());
    }

    public static String formatMode(String mode) {
        return StringUtils.capitalize((String)mode);
    }

    public static String getMode() {
        if (!postInitPassed) {
            return LabsModeHelper.getModePre();
        }
        try {
            Class<?> pmCfgClass = Class.forName("io.sommers.packmode.PMConfig");
            Method getPackModeMethod = pmCfgClass.getDeclaredMethod("getPackMode", new Class[0]);
            Method getCfgMethod = pmCfgClass.getDeclaredMethod("getConfiguration", new Class[0]);
            if (getCfgMethod.invoke(null, new Object[0]) == null) {
                return LabsModeHelper.getModePre();
            }
            String mode = (String)getPackModeMethod.invoke(null, new Object[0]);
            if (!checked) {
                LabsModeHelper.check(mode);
            }
            return mode;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Tried to get mode when PMConfig class is not loaded! Fatal error, this should not happen! Report to Nomi-Labs devs!");
        }
    }

    private static String getModePre() {
        if (modePreCache != null) {
            return modePreCache;
        }
        File configDir = new File(Launch.minecraftHome, "config");
        File packModeCfgFile = new File(configDir, "packmode.cfg");
        if (!packModeCfgFile.exists()) {
            return "normal";
        }
        Configuration configuration = new Configuration(packModeCfgFile);
        configuration.load();
        modePreCache = configuration.get("general", "packMode", "normal").getString();
        if (!checked) {
            LabsModeHelper.check(modePreCache);
        }
        return modePreCache;
    }

    public static void check() {
        if (!checked) {
            LabsModeHelper.getMode();
        }
    }

    public static void onPostInit() {
        postInitPassed = true;
    }

    private static void check(String mode) {
        checked = true;
        if (LabsConfig.advanced.allowOtherPackModes) {
            return;
        }
        if (!mode.equals("normal") && !mode.equals("expert")) {
            throw new IllegalArgumentException("[Nomi Labs]: Pack Mode must be either 'normal' or 'expert'.If you are sure of what you are doing, you can allow other pack modes in the Nomi Labs Config, but beware: many mode specific behaviours will break.");
        }
    }
}

