/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.util;

import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.util.LabsSide;
import gregtech.client.utils.TooltipHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class LabsTranslate {
    public static String translate(String key, Object ... params) {
        if (LabsSide.isDedicatedServer()) {
            return LabsTranslate.translateServerSide(key, params);
        }
        try {
            return net.minecraft.client.resources.I18n.func_135052_a((String)key, (Object[])params);
        }
        catch (Exception e) {
            return LabsTranslate.translateServerSide(key, params);
        }
    }

    private static String translateServerSide(String key, Object ... params) {
        try {
            String localTranslated = I18n.func_74837_a((String)key, (Object[])params);
            if (!localTranslated.equals(key)) {
                return localTranslated;
            }
            String fallbackTranslated = I18n.func_150826_b((String)key);
            if (!fallbackTranslated.equals(key) && params.length != 0) {
                try {
                    fallbackTranslated = String.format(fallbackTranslated, params);
                }
                catch (IllegalFormatException var5) {
                    fallbackTranslated = "Format error: " + fallbackTranslated;
                    NomiLabs.LOGGER.error((Object)var5);
                }
            }
            return fallbackTranslated;
        }
        catch (Exception e) {
            return key;
        }
    }

    public static String translateFormat(String key, TextFormatting format, Object ... params) {
        return LabsTranslate.format(LabsTranslate.translate(key, params), format);
    }

    public static String translateFormat(String key, TooltipHelper.GTFormatCode format, Object ... params) {
        return LabsTranslate.format(LabsTranslate.translate(key, params), format);
    }

    public static String translateFormat(String key, Format format, Object ... params) {
        return LabsTranslate.format(LabsTranslate.translate(key, params), format);
    }

    public static String format(String str, TextFormatting ... formats) {
        return String.join((CharSequence)"", (CharSequence[])Arrays.stream(formats).map(TextFormatting::toString).toArray(String[]::new)) + str + TextFormatting.RESET;
    }

    public static String format(String str, TooltipHelper.GTFormatCode ... formats) {
        return String.join((CharSequence)"", (CharSequence[])Arrays.stream(formats).map(TooltipHelper.GTFormatCode::toString).toArray(String[]::new)) + str + TextFormatting.RESET;
    }

    public static String format(String str, Format ... formats) {
        return String.join((CharSequence)"", (CharSequence[])Arrays.stream(formats).map(Format::getFormat).toArray(String[]::new)) + str + TextFormatting.RESET;
    }

    public static Translatable translatable(String key, Object ... params) {
        return new Translatable(key, params);
    }

    public static Translatable translatableLiteral(String text) {
        return new TranslatableLiteral(text);
    }

    public static Translatable translatableEmpty() {
        return new TranslatableLiteral("");
    }

    public static String topTranslate(String key) {
        return "{*" + key + "*}";
    }

    public static class Format {
        private final String format;
        @Nullable
        private final TooltipHelper.GTFormatCode gtCode;

        private Format(String format, @Nullable TooltipHelper.GTFormatCode gtCode) {
            this.format = format;
            this.gtCode = gtCode;
        }

        public static Format of(TextFormatting format) {
            return new Format(format.toString(), null);
        }

        public static Format of(TooltipHelper.GTFormatCode format) {
            return new Format(format.toString(), format);
        }

        public String getFormat() {
            if (this.gtCode != null) {
                return this.gtCode.toString();
            }
            return this.format;
        }
    }

    public static class Translatable {
        public final String key;
        public final Object[] params;
        protected List<Format> format;
        protected List<Translatable> appended;

        public Translatable(String key, Object ... params) {
            this.key = key;
            this.params = params;
            this.format = new ArrayList<Format>();
            this.appended = new ArrayList<Translatable>();
        }

        public Translatable addFormat(Format format) {
            this.format.add(format);
            return this;
        }

        public Translatable addFormat(TextFormatting format) {
            this.format.add(Format.of(format));
            return this;
        }

        public Translatable addFormat(TooltipHelper.GTFormatCode format) {
            this.format.add(Format.of(format));
            return this;
        }

        public Translatable append(Translatable append) {
            this.appended.add(append);
            return this;
        }

        public ITextComponent toTextComp() {
            return new TextComponentTranslation(this.key, this.params);
        }

        public String translate() {
            String translated = this.translateThis();
            for (Translatable toAppend : this.appended) {
                translated = translated.concat(toAppend.translate());
            }
            return translated;
        }

        protected String translateThis() {
            if (this.format.isEmpty()) {
                return LabsTranslate.translate(this.key, this.params);
            }
            return LabsTranslate.format(LabsTranslate.translate(this.key, this.params), this.format.toArray(new Format[0]));
        }

        public String topVersion() {
            if (this.format.isEmpty()) {
                return LabsTranslate.topTranslate(this.key);
            }
            return LabsTranslate.format(LabsTranslate.topTranslate(this.key), this.format.toArray(new Format[0]));
        }

        public String toString() {
            return this.translate();
        }
    }

    public static class TranslatableLiteral
    extends Translatable {
        public TranslatableLiteral(String text) {
            super(text, new Object[0]);
        }

        @Override
        public ITextComponent toTextComp() {
            return new TextComponentString(this.key);
        }

        @Override
        protected String translateThis() {
            if (this.format.isEmpty()) {
                return this.key;
            }
            return LabsTranslate.format(this.key, this.format.toArray(new Format[0]));
        }

        @Override
        public String topVersion() {
            if (this.format.isEmpty()) {
                return this.key;
            }
            return LabsTranslate.format(this.key, this.format.toArray(new Format[0]));
        }
    }
}

