/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.client.WorldOverlayRenderer;
import thelm.packagedauto.network.ISelfHandleMessage;
import thelm.packagedauto.network.PacketHandler;

public class PacketDirectionalMarker
implements ISelfHandleMessage<IMessage> {
    private List<DirectionalGlobalPos> positions;
    private int color;
    private int lifetime;

    public PacketDirectionalMarker() {
    }

    public PacketDirectionalMarker(List<DirectionalGlobalPos> positions, int color, int lifetime) {
        this.positions = positions;
        this.color = color;
        this.lifetime = lifetime;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.positions.size());
        for (DirectionalGlobalPos globalPos : this.positions) {
            buf.writeInt(globalPos.dimension());
            buf.writeInt(globalPos.x());
            buf.writeInt(globalPos.y());
            buf.writeInt(globalPos.z());
            buf.writeByte(globalPos.direction().func_176745_a());
        }
        buf.writeMedium(this.color);
        buf.writeShort(this.lifetime);
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readByte();
        this.positions = new ArrayList<DirectionalGlobalPos>(size);
        for (int i = 0; i < size; ++i) {
            int dimension = buf.readInt();
            BlockPos pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            EnumFacing direction = EnumFacing.func_82600_a((int)buf.readByte());
            this.positions.add(new DirectionalGlobalPos(dimension, pos, direction));
        }
        this.color = buf.readUnsignedMedium();
        this.lifetime = buf.readUnsignedShort();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> WorldOverlayRenderer.INSTANCE.addDirectionalMarkers(this.positions, this.color, this.lifetime));
        return null;
    }

    public static void sendDirectionalMarkers(EntityPlayerMP player, List<DirectionalGlobalPos> positions, int color, int lifetime) {
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketDirectionalMarker(positions, color, lifetime), player);
    }
}

