/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.tile;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.brandon3055.draconicevolution.api.fusioncrafting.ICraftingInjector;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionCraftingInventory;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.tile.TileBase;
import thelm.packageddraconic.block.BlockMarkedInjector;
import thelm.packageddraconic.energy.EnergyStorageMarkedInjector;
import thelm.packageddraconic.integration.appeng.networking.HostHelperTileMarkedInjector;
import thelm.packageddraconic.inventory.InventoryMarkedInjector;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2")})
public class TileMarkedInjector
extends TileBase
implements ITickable,
ICraftingInjector,
IGridHost,
IActionHost {
    public static int[] chargeRate = new int[]{300, 220, 140, 60};
    public static int[] craftRate = new int[]{2, 3, 5, 7};
    public boolean firstTick = true;
    public EnergyStorageMarkedInjector energyStorage = new EnergyStorageMarkedInjector(this);
    public BlockPos crafterPos = null;
    public int tier = -1;
    public HostHelperTileMarkedInjector hostHelper;

    public TileMarkedInjector() {
        this.setInventory(new InventoryMarkedInjector(this));
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.hostHelper = new HostHelperTileMarkedInjector(this);
        }
    }

    protected String getLocalizedName() {
        return this.func_145838_q().func_149732_F();
    }

    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.field_145850_b.field_72995_K && this.hostHelper != null) {
                this.hostHelper.isActive();
            }
        }
    }

    public void ejectItem() {
        if (this.hostHelper != null && this.hostHelper.isActive()) {
            this.hostHelper.ejectItem();
        }
        ItemStack stack = this.inventory.func_70301_a(0);
        this.inventory.func_70299_a(0, ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            EnumFacing facing = this.getDirection();
            double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25 + (double)facing.func_82601_c() * 0.5;
            double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25 + (double)facing.func_96559_d() * 0.5;
            double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25 + (double)facing.func_82599_e() * 0.5;
            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + dx, (double)this.field_174879_c.func_177956_o() + dy, (double)this.field_174879_c.func_177952_p() + dz, stack);
            entityitem.func_174869_p();
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
    }

    public int getPedestalTier() {
        Block block;
        if (this.tier == -1 && (block = this.func_145838_q()) instanceof BlockMarkedInjector) {
            this.tier = ((BlockMarkedInjector)block).tier;
        }
        return this.tier;
    }

    public int getChargeRate() {
        return chargeRate[MathHelper.func_76125_a((int)this.getPedestalTier(), (int)0, (int)(chargeRate.length - 1))];
    }

    public int getCraftRate() {
        return craftRate[MathHelper.func_76125_a((int)this.getPedestalTier(), (int)0, (int)(craftRate.length - 1))];
    }

    public ItemStack getStackInPedestal() {
        return this.inventory.func_70301_a(0);
    }

    public void setStackInPedestal(ItemStack stack) {
        this.inventory.func_70299_a(0, stack);
    }

    public boolean setCraftingInventory(IFusionCraftingInventory craftingInventory) {
        if (craftingInventory == null) {
            this.crafterPos = null;
            return false;
        }
        if (this.validateCraftingInventory() && !this.field_145850_b.field_72995_K) {
            return false;
        }
        this.crafterPos = ((TileEntity)craftingInventory).func_174877_v();
        return true;
    }

    public IFusionCraftingInventory getCraftingInventory() {
        TileEntity tile;
        this.validateCraftingInventory();
        if (this.crafterPos != null && (tile = this.field_145850_b.func_175625_s(this.crafterPos)) instanceof IFusionCraftingInventory) {
            return (IFusionCraftingInventory)tile;
        }
        return null;
    }

    public EnumFacing getDirection() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockMarkedInjector) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N);
        }
        return EnumFacing.UP;
    }

    public long getInjectorCharge() {
        return this.energyStorage.getExtendedEnergyStored();
    }

    public boolean validateCraftingInventory() {
        TileEntity tile;
        if (!this.getStackInPedestal().func_190926_b() && this.crafterPos != null && (tile = this.field_145850_b.func_175625_s(this.crafterPos)) instanceof IFusionCraftingInventory && !tile.func_145837_r() && ((IFusionCraftingInventory)tile).craftingInProgress()) {
            return true;
        }
        this.crafterPos = null;
        return false;
    }

    public void onCraft() {
        if (this.crafterPos != null) {
            this.energyStorage.setEnergyStored(0L);
            this.crafterPos = null;
        }
    }

    public int getComparatorSignal() {
        return this.inventory.func_70301_a(0).func_190926_b() ? 0 : 15;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (this.hostHelper != null) {
            this.hostHelper.readFromNBT(nbt);
        }
        super.func_145839_a(nbt);
        this.energyStorage.readFromNBT(nbt);
        this.crafterPos = null;
        if (nbt.func_74764_b("CrafterPos")) {
            int[] posArray = nbt.func_74759_k("CrafterPos");
            this.crafterPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.energyStorage.writeToNBT(nbt);
        if (this.crafterPos != null) {
            nbt.func_74783_a("CrafterPos", new int[]{this.crafterPos.func_177958_n(), this.crafterPos.func_177956_o(), this.crafterPos.func_177952_p()});
        }
        if (this.hostHelper != null) {
            this.hostHelper.writeToNBT(nbt);
        }
        return nbt;
    }

    public void readSyncNBT(NBTTagCompound nbt) {
        super.readSyncNBT(nbt);
        this.inventory.readFromNBT(nbt);
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        super.writeSyncNBT(nbt);
        this.inventory.writeToNBT(nbt);
        return nbt;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability == CapabilityEnergy.ENERGY && this.getDirection() != from || super.hasCapability(capability, from);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY && this.getDirection() != facing ? this.energyStorage : super.getCapability(capability, facing));
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return null;
    }

    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return null;
    }
}

