/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.recipe;

import com.blakebr0.extendedcrafting.block.ModBlocks;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedexcrafting.recipe.RecipeInfoElite;
import thelm.packagedexcrafting.recipe.RecipeTypeAdvanced;

public class RecipeTypeElite
implements IRecipeType {
    public static final RecipeTypeElite INSTANCE = new RecipeTypeElite();
    public static final ResourceLocation NAME = new ResourceLocation("packagedexcrafting:elite");
    public static final IntSet SLOTS;
    public static final List<String> CATEGORIES;
    public static final Color COLOR;
    public static final Color COLOR_DISABLED;

    protected RecipeTypeElite() {
    }

    public ResourceLocation getName() {
        return NAME;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)"recipe.packagedexcrafting.elite");
    }

    public String getLocalizedNameShort() {
        return I18n.func_74838_a((String)"recipe.packagedexcrafting.elite.short");
    }

    public IRecipeInfo getNewRecipeInfo() {
        return new RecipeInfoElite();
    }

    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    public List<String> getJEICategories() {
        return CATEGORIES;
    }

    @Optional.Method(modid="jei")
    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeLayout recipeLayout, String category) {
        if (category.equals(CATEGORIES.get(0))) {
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
            Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
            int index = 0;
            int[] slotArray = SLOTS.toIntArray();
            for (Map.Entry entry : ingredients.entrySet()) {
                IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
                if (ingredient.isInput()) {
                    ItemStack displayed = (ItemStack)((IGuiIngredient)entry.getValue()).getDisplayedIngredient();
                    if (displayed != null && !displayed.func_190926_b()) {
                        map.put(slotArray[index], (Object)displayed);
                    }
                    ++index;
                }
                if (index < 49) continue;
                break;
            }
            return map;
        }
        return RecipeTypeAdvanced.INSTANCE.getRecipeTransferMap(recipeLayout, category);
    }

    @SideOnly(value=Side.CLIENT)
    public Object getRepresentation() {
        return new ItemStack((Block)ModBlocks.blockEliteTable);
    }

    @SideOnly(value=Side.CLIENT)
    public Color getSlotColor(int slot) {
        if (!SLOTS.contains(slot) && slot != 85) {
            return COLOR_DISABLED;
        }
        return COLOR;
    }

    static {
        CATEGORIES = ImmutableList.of((Object)"extendedcrafting:table_crafting_7x7", (Object)"extendedcrafting:table_crafting_5x5", (Object)"extendedcrafting:table_crafting_3x3");
        COLOR = new Color(139, 139, 139);
        COLOR_DISABLED = new Color(64, 64, 64);
        SLOTS = new IntRBTreeSet();
        for (int i = 1; i < 8; ++i) {
            for (int j = 1; j < 8; ++j) {
                SLOTS.add(9 * i + j);
            }
        }
    }
}

