/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.tile;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedexcrafting.integration.appeng.networking.HostHelperTileMarkedPedestal;
import thelm.packagedexcrafting.inventory.InventoryMarkedPedestal;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2")})
public class TileMarkedPedestal
extends TileBase
implements ITickable,
IGridHost,
IActionHost {
    public boolean firstTick = true;
    public HostHelperTileMarkedPedestal hostHelper;

    public TileMarkedPedestal() {
        this.setInventory(new InventoryMarkedPedestal(this));
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.hostHelper = new HostHelperTileMarkedPedestal(this);
        }
    }

    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagedexcrafting.marked_pedestal.name");
    }

    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.field_145850_b.field_72995_K && this.hostHelper != null) {
                this.hostHelper.isActive();
            }
        }
    }

    public void ejectItem() {
        if (this.hostHelper != null && this.hostHelper.isActive()) {
            this.hostHelper.ejectItem();
        }
        ItemStack stack = this.inventory.func_70301_a(0);
        this.inventory.func_70299_a(0, ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
            double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.75;
            double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + dx, (double)this.field_174879_c.func_177956_o() + dy, (double)this.field_174879_c.func_177952_p() + dz, stack);
            entityitem.func_174869_p();
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
    }

    public int getComparatorSignal() {
        return this.inventory.func_70301_a(0).func_190926_b() ? 0 : 15;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (this.hostHelper != null) {
            this.hostHelper.readFromNBT(nbt);
        }
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.hostHelper != null) {
            this.hostHelper.writeToNBT(nbt);
        }
        return nbt;
    }

    public void readSyncNBT(NBTTagCompound nbt) {
        super.readSyncNBT(nbt);
        this.inventory.readFromNBT(nbt);
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        super.writeSyncNBT(nbt);
        this.inventory.writeToNBT(nbt);
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return null;
    }

    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return null;
    }
}

