/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui.guielements;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UV;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.projectintelligence.client.PITextures;
import com.brandon3055.projectintelligence.client.StyleHandler;
import com.brandon3055.projectintelligence.client.gui.PIConfig;
import com.brandon3055.projectintelligence.client.gui.PIGuiContainer;
import com.brandon3055.projectintelligence.client.gui.PIPartRenderer;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiNotifications;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiPartMDWindow;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiPartMenu;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiPartPageList;
import com.brandon3055.projectintelligence.client.gui.guielements.StyledGuiButton;
import com.brandon3055.projectintelligence.client.keybinding.KeyInputHandler;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;

public class GuiPIIntroduction
extends MGuiElementBase<GuiPIIntroduction> {
    private static StyleHandler.PropertyGroup windowProps = new StyleHandler.PropertyGroup("user_dialogs");
    private static StyleHandler.PropertyGroup buttonProps = new StyleHandler.PropertyGroup("user_dialogs.button_style");
    private PIGuiContainer container;
    private List<InfoScreen> screens = new LinkedList<InfoScreen>();
    private int selectedScreen = 0;

    public GuiPIIntroduction(PIGuiContainer container) {
        this.container = container;
        this.addInfoScreens();
    }

    private void addInfoScreens() {
        this.screens.add((InfoScreen)new InfoScreen(this, "pi.info_screen.welcome.title", "pi.info_screen.welcome.text", new Object[0]).setSize(250, 200));
        this.screens.add((InfoScreen)new InfoScreen(this, "pi.info_screen.guide_intro.title", "pi.info_screen.guide_intro.text", new Object[0]).setSize(250, 120));
        this.screens.add((InfoScreen)new OverviewScreen(this, "pi.info_screen.basic_overview.title", "pi.info_screen.basic_overview.text").setSize(150, 90));
        this.screens.add((InfoScreen)new InfoScreen(this, "pi.info_screen.pi_interaction.title", "pi.info_screen.pi_interaction.text", new Object[]{KeyInputHandler.openPI.getDisplayName(), KeyInputHandler.etGUI.getDisplayName(), KeyInputHandler.etWorld.getDisplayName()}).setSize(250, 200));
        this.screens.add((InfoScreen)new StyleScreen(this, "pi.info_screen.ui_style.title", "pi.info_screen.ui_style.text").setSize(250, 100));
        this.screens.add((InfoScreen)new InfoScreen(this, "pi.info_screen.contributing.title", "pi.info_screen.contributing.text", new Object[0]).setSize(250, 100));
    }

    public void addChildElements() {
        super.addChildElements();
        this.addChildren(this.screens);
        this.screens.forEach(screen -> {
            InfoScreen cfr_ignored_0 = (InfoScreen)screen.setEnabledCallback(() -> this.screens.indexOf(screen) == this.selectedScreen);
        });
    }

    private void nextScreen() {
        if (this.selectedScreen + 1 == this.screens.size()) {
            this.close(false);
            return;
        }
        this.selectedScreen = MathHelper.clip((int)(this.selectedScreen + 1), (int)0, (int)(this.screens.size() - 1));
        this.screens.get(this.selectedScreen).onScreenDisplayed();
    }

    private void prevScreen() {
        if (this.selectedScreen == 0) {
            this.close(false);
            return;
        }
        this.selectedScreen = MathHelper.clip((int)(this.selectedScreen - 1), (int)0, (int)(this.screens.size() - 1));
        this.screens.get(this.selectedScreen).onScreenDisplayed();
    }

    private void close(boolean showLater) {
        if (showLater) {
            PIConfig.showTutorialLater = true;
            GuiNotifications.addNotification(I18n.func_135052_a((String)"pi.notification.show_tutorial_later.txt", (Object[])new Object[0]), 5);
        } else {
            PIConfig.tutorialDisplayed = true;
            PIConfig.save();
        }
        this.modularGui.getManager().remove((MGuiElementBase)this);
    }

    protected boolean keyTyped(char typedChar, int keyCode) throws IOException {
        if (keyCode == 59 || keyCode == 1) {
            this.close(!PIConfig.tutorialDisplayed);
            return true;
        }
        return super.keyTyped(typedChar, keyCode);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        return true;
    }

    public boolean handleMouseScroll(int mouseX, int mouseY, int scrollDirection) {
        super.handleMouseScroll(mouseX, mouseY, scrollDirection);
        return true;
    }

    static /* synthetic */ StyleHandler.PropertyGroup access$400() {
        return buttonProps;
    }

    private static class StyleScreen
    extends InfoScreen {
        private GuiButton nextStyle;
        int index = 0;

        private StyleScreen(GuiPIIntroduction parent, String unLocalTitle, String unLocalInfo) {
            super(parent, unLocalTitle, unLocalInfo, new Object[0]);
        }

        @Override
        public void addChildElements() {
            super.addChildElements();
            this.nextStyle = new StyledGuiButton(this.buttonRenderer);
            this.nextStyle.setText(I18n.func_135052_a((String)"pi.button.next_style", (Object[])new Object[0]));
            this.nextStyle.setListener(this::nextStyle);
            this.nextStyle.setSize(80, 14);
            this.addChild((MGuiElementBase)this.nextStyle);
        }

        @Override
        public void reloadElement() {
            super.reloadElement();
            this.nextStyle.setPos(this.xPos() + this.xSize() / 2 - this.nextStyle.xSize() / 2, this.prevButton.yPos());
            this.nextButton.setDisabled(StyleHandler.getDefaultPresets().isEmpty());
        }

        private void nextStyle() {
            ++this.index;
            ArrayList<String> presets = new ArrayList<String>(StyleHandler.getDefaultPresets());
            String preset = (String)presets.get(this.index % presets.size());
            StyleHandler.loadPreset(preset, false);
        }
    }

    private static class OverviewScreen
    extends InfoScreen {
        private List<InfoArrow> arrows = new LinkedList<InfoArrow>();

        private OverviewScreen(GuiPIIntroduction parent, String unLocalTitle, String unLocalInfo) {
            super(parent, unLocalTitle, unLocalInfo, new Object[0]);
        }

        @Override
        public void reloadElement() {
            super.reloadElement();
            DelayedTask.run((int)1, this::onScreenDisplayed);
        }

        private InfoArrow addArrow(int targetX, int targetY, String info) {
            InfoArrow arrow = new InfoArrow(targetX, targetY, info);
            this.addChild(arrow);
            this.arrows.add(arrow);
            return arrow;
        }

        private void addArrow(MGuiElementBase target, String info) {
            this.addArrow(target.xPos() + target.xSize() / 2, target.yPos() + target.ySize() / 2, info).setHighlight(target.getRect());
        }

        @Override
        protected void onScreenDisplayed() {
            this.toRemove.addAll(this.arrows);
            this.arrows.forEach(infoArrow -> {
                InfoArrow cfr_ignored_0 = (InfoArrow)infoArrow.setEnabled(false);
            });
            GuiPartPageList list = this.parent.container.getPageList();
            GuiPartMenu menu = this.parent.container.getMenu();
            GuiPartMDWindow content = this.parent.container.getMdWindow();
            if (list != null) {
                list.setFullyExtended();
                Rectangle r = (Rectangle)list.backButton.getRect().clone();
                r.add(list.forwardButton.getRect());
                this.addArrow(list.backButton.maxXPos(), list.backButton.yPos() + list.backButton.ySize() / 2, "pi.intro.arrow_info.back_forward.txt").setHighlight(r);
                this.addArrow((MGuiElementBase)list.toggleView, "pi.intro.arrow_info.toggle_nav.txt");
                this.addArrow(list.scrollElement.xPos() + list.scrollElement.xSize() / 2, this.screenHeight / 3, "pi.intro.arrow_info.button_list.txt").setHighlight(list.scrollElement.getRect());
                this.addArrow(7, this.screenHeight / 2, "pi.intro.arrow_info.current_directory.txt").setHighlight(new Rectangle(0, list.scrollElement.yPos(), list.scrollElement.xPos(), list.scrollElement.ySize()));
                this.addArrow((MGuiElementBase)list.searchBox, "pi.intro.arrow_info.search_box.txt");
                this.addArrow((MGuiElementBase)list.searchSettings, "pi.intro.arrow_info.search_settings.txt");
            }
            if (menu != null) {
                this.addArrow((MGuiElementBase)menu.settingsButton, "pi.intro.arrow_info.settings.txt");
                this.addArrow((MGuiElementBase)menu.minimizeButton, "pi.intro.arrow_info.minimize.txt");
            }
            this.addArrow(content.xPos() + content.xSize() / 2, content.yPos() + 8, "pi.intro.arrow_info.content_tabs.txt").setHighlight(new Rectangle(content.xPos(), content.yPos(), content.xSize(), 12));
            this.addArrow(content.xPos() + content.xSize() / 2, content.yPos() + content.ySize() / 4, "pi.intro.arrow_info.content_window.txt").setHighlight(new Rectangle(content.xPos(), content.yPos() + 12, content.xSize(), content.ySize() - 12));
        }

        private static class InfoArrow
        extends MGuiElementBase<InfoArrow> {
            private final int targetX;
            private final int targetY;
            private final String info;
            private double animProgress = 0.0;
            private static final CCModel arrowModel = CCModel.quadModel((int)4);
            private CCModel activeModel = arrowModel.copy();
            private Rectangle highlight;

            public InfoArrow(int targetX, int targetY, String info) {
                this.targetX = targetX;
                this.targetY = targetY;
                this.info = info;
            }

            public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                super.renderElement(minecraft, mouseX, mouseY, partialTicks);
                GlStateManager.func_179097_i();
                this.bindTexture(PITextures.PI_PARTS);
                CCRenderState ccrs = CCRenderState.instance();
                ccrs.startDrawing(7, DefaultVertexFormats.field_181707_g);
                this.activeModel.render(ccrs, new IVertexOperation[0]);
                ccrs.draw();
                GlStateManager.func_179126_j();
            }

            public InfoArrow setHighlight(Rectangle highlight) {
                this.highlight = highlight;
                return this;
            }

            public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                Vertex5[] v = this.activeModel.verts;
                int[] x = new int[]{(int)v[0].vec.x, (int)v[1].vec.x, (int)v[2].vec.x, (int)v[3].vec.x};
                int[] y = new int[]{(int)v[0].vec.y, (int)v[1].vec.y, (int)v[2].vec.y, (int)v[3].vec.y};
                Polygon polygon = new Polygon(x, y, 4);
                if (polygon.contains(mouseX, mouseY)) {
                    if (this.highlight != null) {
                        this.drawColouredRect(this.highlight.x, this.highlight.y, this.highlight.width, this.highlight.height, 0x4000FF00);
                    }
                    this.drawHoveringText(Collections.singletonList(I18n.func_135052_a((String)this.info, (Object[])new Object[0])), mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
                    return true;
                }
                return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
            }

            public boolean onUpdate() {
                if (this.animProgress < 1.0) {
                    this.animProgress = MathHelper.clip((double)(this.animProgress + 0.15), (double)0.0, (double)1.0);
                    double d = MathHelper.clip((double)this.animProgress, (double)0.0, (double)1.0);
                    int centerX = this.screenWidth / 2;
                    int centerY = this.screenHeight / 2;
                    double dist = Utils.getDistanceAtoB((double)centerX, (double)centerY, (double)this.targetX, (double)this.targetY) * d;
                    this.activeModel = arrowModel.copy();
                    Vector3 offset = new Vector3((double)this.targetX - (double)this.screenWidth / 2.0, (double)this.targetY - (double)this.screenHeight / 2.0, 0.0).normalize();
                    this.activeModel.apply((Transformation)new Translation(-dist, -8.0, 0.0));
                    this.activeModel.apply((Transformation)new Rotation(Math.atan2(offset.x, offset.y) + 1.5707963267948701, 0.0, 0.0, -1.0));
                    this.activeModel.apply((Transformation)new Translation((double)centerX, (double)centerY, (double)this.displayZLevel));
                }
                return super.onUpdate();
            }

            static {
                double px = 0.00390625;
                InfoArrow.arrowModel.verts[3] = new Vertex5(new Vector3(0.0, 16.0, 0.0), new UV(px * 16.0, px * 48.0));
                InfoArrow.arrowModel.verts[2] = new Vertex5(new Vector3(0.0, 0.0, 0.0), new UV(px * 16.0, px * 32.0));
                InfoArrow.arrowModel.verts[1] = new Vertex5(new Vector3(24.0, 0.0, 0.0), new UV(px * 40.0, px * 32.0));
                InfoArrow.arrowModel.verts[0] = new Vertex5(new Vector3(24.0, 16.0, 0.0), new UV(px * 40.0, px * 48.0));
                arrowModel.computeNormals();
            }
        }
    }

    private static class InfoScreen
    extends MGuiElementBase<InfoScreen> {
        protected PIPartRenderer windowRenderer = new PIPartRenderer(GuiPIIntroduction.access$300());
        protected PIPartRenderer buttonRenderer = new PIPartRenderer(GuiPIIntroduction.access$400()).setButtonRender(true);
        protected GuiPIIntroduction parent;
        protected final GuiLabel title;
        protected final GuiLabel info;
        protected GuiScrollElement infoContainer;
        protected StyledGuiButton nextButton;
        protected StyledGuiButton prevButton;
        protected GuiButton later;

        private InfoScreen(GuiPIIntroduction parent, String unLocalTitle, String unLocalInfo, Object ... localParamaters) {
            this.parent = parent;
            this.title = new GuiLabel(I18n.func_135052_a((String)unLocalTitle, (Object[])new Object[0]));
            this.info = new GuiLabel(I18n.func_135052_a((String)unLocalInfo, (Object[])localParamaters).replace("  ", "\n\n"));
        }

        public void addChildElements() {
            this.title.setAlignment(GuiAlign.CENTER);
            this.title.setWrap(true).setShadow(false);
            this.title.setTextColour(windowProps.textColour());
            this.info.setWrap(true).setShadow(false);
            this.info.setTextColour(windowProps.textColour());
            this.infoContainer = new GuiScrollElement();
            this.infoContainer.setListMode(GuiScrollElement.ListMode.VERT_LOCK_POS_WIDTH);
            this.infoContainer.setInsets(3, 5, 1, 5);
            this.infoContainer.setStandardScrollBehavior();
            this.addChild((MGuiElementBase)this.title);
            this.addChild((MGuiElementBase)this.infoContainer);
            this.infoContainer.addElement((MGuiElementBase)this.info);
            int index = this.parent.screens.indexOf((Object)this);
            this.nextButton = new StyledGuiButton(this.buttonRenderer);
            ((StyledGuiButton)this.addChild((MGuiElementBase)this.nextButton)).setText(I18n.func_135052_a((String)(index == this.parent.screens.size() - 1 ? "pi.button.close" : "pi.button.next"), (Object[])new Object[0]));
            this.prevButton = new StyledGuiButton(this.buttonRenderer);
            ((StyledGuiButton)this.addChild((MGuiElementBase)this.prevButton)).setText(I18n.func_135052_a((String)(index == 0 ? "pi.button.skip" : "pi.button.previous"), (Object[])new Object[0]));
            if (index == 0 && PIConfig.tutorialDisplayed && !PIConfig.showTutorialLater) {
                this.later = new StyledGuiButton(this.buttonRenderer).setText(I18n.func_135052_a((String)"pi.button.show_me_later", (Object[])new Object[0]));
                this.later.setListener(() -> this.parent.close(true));
                this.later.setTrim(false);
                this.addChild((MGuiElementBase)this.later);
            }
            this.nextButton.setListener(() -> this.parent.nextScreen());
            this.prevButton.setListener(() -> this.parent.prevScreen());
            super.addChildElements();
        }

        public void reloadElement() {
            this.setPos(this.screenWidth / 2 - this.xSize() / 2, this.screenHeight / 2 - this.ySize() / 2);
            ((GuiLabel)this.title.setPos(this.xPos() + 3, this.yPos() + 4)).setHeightForText(this.xSize() - 6);
            this.infoContainer.setPos(this.xPos(), this.title.maxYPos() + 2);
            this.infoContainer.setSize(this.xSize() - 4, this.ySize() - this.title.ySize() - 26);
            this.info.setHeightForText(this.infoContainer.getInsetRect().width);
            this.infoContainer.updateScrollElement();
            this.prevButton.setSize(60, 14);
            this.prevButton.setPos(this.xPos() + 4, this.maxYPos() - this.prevButton.ySize() - 4);
            this.nextButton.setSize(60, 14);
            this.nextButton.setPos(this.maxXPos() - this.nextButton.xSize() - 4, this.maxYPos() - this.prevButton.ySize() - 4);
            if (this.later != null) {
                this.later.setSize(100, 14);
                this.later.setPos(this.xPos() + this.xSize() / 2 - this.later.xSize() / 2, this.maxYPos() - this.prevButton.ySize() - 4);
            }
            super.reloadElement();
        }

        protected void onScreenDisplayed() {
        }

        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            this.windowRenderer.render(this);
            this.drawColouredRect(this.title.xPos(), this.title.yPos() - 1, this.title.xSize(), this.title.ySize() + 1, this.changeShade(windowProps.colour(), -0.2));
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }
}

