/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.realbench.logic;

import com.nomiceu.realbench.logic.TileContainerWorkbench;
import com.nomiceu.realbench.logic.TileEntityWorkbench;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InventoryWorkbench
extends InventoryCrafting {
    private final ContainerWorkbench container;
    @Nullable
    private final TileEntityWorkbench tile;
    private final int width;
    private final int height;

    public InventoryWorkbench(ContainerWorkbench container, int width, int height) {
        super((Container)container, width, height);
        this.container = container;
        this.width = width;
        this.height = height;
        this.tile = ((TileContainerWorkbench)container).getTile();
        if (this.tile != null) {
            this.tile.ensureCraftMatrixCapacity(width * height);
        }
    }

    public int func_70302_i_() {
        if (this.tile == null) {
            return super.func_70302_i_();
        }
        return this.tile.craftMatrix.size();
    }

    public boolean func_191420_l() {
        if (this.tile == null) {
            return super.func_191420_l();
        }
        for (ItemStack itemstack : this.tile.getCraftMatrixSafe()) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack func_70301_a(int index) {
        if (this.tile == null) {
            return super.func_70301_a(index);
        }
        return index >= this.func_70302_i_() ? ItemStack.field_190927_a : this.tile.getCraftMatrixSafe().get(index);
    }

    @NotNull
    public ItemStack func_70463_b(int row, int column) {
        if (this.tile == null) {
            return super.func_70463_b(row, column);
        }
        return row >= 0 && row < this.width && column >= 0 && column <= this.height ? this.func_70301_a(row + column * this.width) : ItemStack.field_190927_a;
    }

    @NotNull
    public ItemStack func_70304_b(int index) {
        if (this.tile == null) {
            return super.func_70304_b(index);
        }
        return ItemStackHelper.func_188383_a(this.tile.craftMatrix, (int)index);
    }

    public void func_70296_d() {
        if (this.tile == null) {
            super.func_70296_d();
            return;
        }
        this.tile.func_70296_d();
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        if (stack == null) {
            stack = ItemStack.field_190927_a;
        }
        if (this.tile == null) {
            super.func_70299_a(index, stack);
            return;
        }
        this.tile.craftMatrix.set(index, (Object)stack);
        ((TileContainerWorkbench)this.container).updateResult();
        this.func_70296_d();
    }

    @MethodsReturnNonnullByDefault
    @NotNull
    public ItemStack func_70298_a(int index, int count) {
        if (this.tile == null) {
            return super.func_70298_a(index, count);
        }
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.tile.craftMatrix, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            ((TileContainerWorkbench)this.container).updateResult();
        }
        this.func_70296_d();
        return itemstack;
    }

    public void func_194018_a(@NotNull RecipeItemHelper helper) {
        if (this.tile == null) {
            super.func_194018_a(helper);
            return;
        }
        for (ItemStack itemstack : this.tile.getCraftMatrixSafe()) {
            helper.func_194112_a(itemstack);
        }
        this.func_70296_d();
    }

    public void func_174888_l() {
        if (this.tile == null) {
            super.func_174888_l();
            return;
        }
        this.tile.craftMatrix.clear();
        this.func_70296_d();
    }
}

