/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.realbench.logic;

import com.google.common.collect.ImmutableList;
import com.nomiceu.realbench.logic.TileContainerWorkbench;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.NotNull;

public class TileEntityWorkbench
extends TileEntity
implements ITickable {
    public NonNullList<ItemStack> craftMatrix = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private final Set<ContainerWorkbench> containers = new ObjectOpenHashSet();
    private boolean needsClear = false;
    private boolean needsUpdate;

    public TileEntityWorkbench addContainer(@NotNull ContainerWorkbench container) {
        this.containers.add(container);
        this.needsUpdate = true;
        return this;
    }

    public void removeContainer(@NotNull ContainerWorkbench container) {
        this.containers.remove(container);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            if (!this.field_145850_b.field_72995_K) {
                WorldServer worldServer = (WorldServer)this.field_145850_b;
                worldServer.func_184164_w().func_180244_a(this.field_174879_c);
                this.updateContainers();
            } else {
                this.needsUpdate = true;
            }
        }
    }

    public List<ItemStack> getCraftMatrixSafe() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack stack : this.craftMatrix) {
            builder.add((Object)(stack == null ? ItemStack.field_190927_a : stack));
        }
        return builder.build();
    }

    private void writeSlots(NBTTagCompound nbt) {
        nbt.func_74768_a("Capacity", this.craftMatrix.size());
        for (int i = 0; i < 9; ++i) {
            if (((ItemStack)this.craftMatrix.get(i)).func_190926_b()) {
                nbt.func_82580_o("Slot" + i);
                continue;
            }
            NBTTagCompound slot = new NBTTagCompound();
            ((ItemStack)this.craftMatrix.get(i)).func_77955_b(slot);
            nbt.func_74782_a("Slot" + i, (NBTBase)slot);
        }
    }

    private void readSlots(NBTTagCompound nbt) {
        int capacity = 9;
        if (nbt.func_150297_b("Capacity", 3)) {
            capacity = nbt.func_74762_e("Capacity");
        }
        this.ensureCraftMatrixCapacity(capacity);
        for (int i = 0; i < 9; ++i) {
            if (!nbt.func_150297_b("Slot" + i, 10)) {
                this.craftMatrix.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            this.craftMatrix.set(i, (Object)new ItemStack(nbt.func_74775_l("Slot" + i)));
        }
    }

    public boolean hasMatrixChanged(List<ItemStack> oldMatrix, List<ItemStack> newMatrix) {
        if (oldMatrix.size() != newMatrix.size()) {
            return true;
        }
        for (int i = 0; i < oldMatrix.size(); ++i) {
            if (ItemStack.func_77989_b((ItemStack)oldMatrix.get(i), (ItemStack)newMatrix.get(i))) continue;
            return true;
        }
        return false;
    }

    public void func_145839_a(@NotNull NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readSlots(nbt);
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeSlots(nbt);
        return nbt;
    }

    @NotNull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.writeSlots(nbt);
        return nbt;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void handleUpdateTag(@NotNull NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.readSlots(tag);
    }

    public void onDataPacket(@NotNull NetworkManager net, @NotNull SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void ensureCraftMatrixCapacity(int capacity) {
        if (this.craftMatrix.size() != capacity) {
            this.craftMatrix = NonNullList.func_191197_a((int)capacity, (Object)ItemStack.field_190927_a);
            this.updateAllOldMatrix();
        }
    }

    public void updateAllOldMatrix() {
        for (ContainerWorkbench container : this.containers) {
            if (container == null) {
                this.containers.remove(null);
                continue;
            }
            ((TileContainerWorkbench)container).updateOldMatrix((List<ItemStack>)this.craftMatrix);
        }
    }

    public void func_73660_a() {
        if (this.needsClear) {
            this.craft();
        }
        if (this.needsUpdate) {
            this.updateContainers();
        }
    }

    private void updateContainers() {
        this.cleanContainers();
        for (ContainerWorkbench container : this.containers) {
            TileContainerWorkbench tileContainer = (TileContainerWorkbench)container;
            if (!this.hasMatrixChanged(tileContainer.getOldMatrix(), (List<ItemStack>)this.craftMatrix)) continue;
            tileContainer.updateResult();
        }
        this.needsUpdate = false;
    }

    public void craft() {
        this.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            this.needsClear = true;
            return;
        }
        for (ContainerWorkbench container : this.containers) {
            if (container == null) {
                this.containers.remove(null);
                continue;
            }
            ((TileContainerWorkbench)container).updateResult();
        }
        this.needsClear = false;
    }

    public void cleanContainers() {
        for (ContainerWorkbench container : this.containers) {
            if (container == null) {
                this.containers.remove(null);
                continue;
            }
            TileContainerWorkbench tileContainer = (TileContainerWorkbench)container;
            if (tileContainer.getPlayer() != null && !tileContainer.getPlayer().field_70128_L) continue;
            this.containers.remove(tileContainer);
        }
    }
}

